/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Objects;
import com.google.gerrit.extensions.common.SubmitType;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;

public class ConflictKey
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final ObjectId commit;
    private final ObjectId otherCommit;
    private final SubmitType submitType;
    private final boolean contentMerge;

    public ConflictKey(ObjectId commit, ObjectId otherCommit, SubmitType submitType, boolean contentMerge) {
        if (SubmitType.FAST_FORWARD_ONLY.equals((Object)submitType) || commit.compareTo(otherCommit) < 0) {
            this.commit = commit;
            this.otherCommit = otherCommit;
        } else {
            this.commit = otherCommit;
            this.otherCommit = commit;
        }
        this.submitType = submitType;
        this.contentMerge = contentMerge;
    }

    public ObjectId getCommit() {
        return this.commit;
    }

    public ObjectId getOtherCommit() {
        return this.otherCommit;
    }

    public SubmitType getSubmitType() {
        return this.submitType;
    }

    public boolean isContentMerge() {
        return this.contentMerge;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConflictKey)) {
            return false;
        }
        ConflictKey other = (ConflictKey)o;
        return this.commit.equals(other.commit) && this.otherCommit.equals(other.otherCommit) && this.submitType.equals((Object)other.submitType) && this.contentMerge == other.contentMerge;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.commit, this.otherCommit, this.submitType, this.contentMerge});
    }
}

