/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ListCaches;
import com.google.gerrit.server.config.PostCaches;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="flushCaches")
@CommandMetaData(name="flush-caches", description="Flush some/all server caches from memory", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class FlushCaches
extends SshCommand {
    @Option(name="--cache", usage="flush named cache", metaVar="NAME")
    private List<String> caches = new ArrayList<String>();
    @Option(name="--all", usage="flush all caches")
    private boolean all;
    @Option(name="--list", usage="list available caches")
    private boolean list;
    @Inject
    private Provider<ListCaches> listCaches;
    @Inject
    private PostCaches postCaches;

    FlushCaches() {
    }

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            if (this.list) {
                if (this.all || this.caches.size() > 0) {
                    throw FlushCaches.error("error: cannot use --list with --all or --cache");
                }
                this.doList();
                return;
            }
            if (this.all && this.caches.size() > 0) {
                throw FlushCaches.error("error: cannot combine --all and --cache");
            }
            if (!this.all && this.caches.size() == 1 && this.caches.contains("all")) {
                this.caches.clear();
                this.all = true;
            } else if (!this.all && this.caches.isEmpty()) {
                this.all = true;
            }
            if (this.all) {
                this.postCaches.apply(new ConfigResource(), new PostCaches.Input(PostCaches.Operation.FLUSH_ALL));
            } else {
                this.postCaches.apply(new ConfigResource(), new PostCaches.Input(PostCaches.Operation.FLUSH, this.caches));
            }
        }
        catch (RestApiException e) {
            throw this.die(e.getMessage());
        }
    }

    private static BaseCommand.UnloggedFailure error(String msg) {
        return new BaseCommand.UnloggedFailure(1, msg);
    }

    private void doList() {
        for (String name : (List)this.listCaches.get().setFormat(ListCaches.OutputFormat.LIST).apply(new ConfigResource())) {
            this.stderr.print(name);
            this.stderr.print('\n');
        }
        this.stderr.flush();
    }
}

