/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

final class Stemmer {
    private final Dictionary dictionary;
    private final BytesRef scratch = new BytesRef();
    private final StringBuilder segment = new StringBuilder();
    private final ByteArrayDataInput affixReader;
    private final StringBuilder scratchSegment = new StringBuilder();
    private char[] scratchBuffer = new char[32];

    public Stemmer(Dictionary dictionary) {
        this.dictionary = dictionary;
        this.affixReader = new ByteArrayDataInput(dictionary.affixData);
    }

    public List<CharsRef> stem(String word) {
        return this.stem(word.toCharArray(), word.length());
    }

    public List<CharsRef> stem(char[] word, int length) {
        if (this.dictionary.needsInputCleaning) {
            this.scratchSegment.setLength(0);
            this.scratchSegment.append(word, 0, length);
            CharSequence cleaned = this.dictionary.cleanInput(this.scratchSegment, this.segment);
            this.scratchBuffer = ArrayUtil.grow(this.scratchBuffer, cleaned.length());
            length = this.segment.length();
            this.segment.getChars(0, length, this.scratchBuffer, 0);
            word = this.scratchBuffer;
        }
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        IntsRef forms = this.dictionary.lookupWord(word, 0, length);
        if (forms != null) {
            for (int i = 0; i < forms.length; ++i) {
                stems.add(this.newStem(word, length));
            }
        }
        stems.addAll(this.stem(word, length, -1, -1, -1, 0, true, true, false, false));
        return stems;
    }

    public List<CharsRef> uniqueStems(char[] word, int length) {
        List<CharsRef> stems = this.stem(word, length);
        if (stems.size() < 2) {
            return stems;
        }
        CharArraySet terms = new CharArraySet(Version.LUCENE_CURRENT, 8, this.dictionary.ignoreCase);
        ArrayList<CharsRef> deduped = new ArrayList<CharsRef>();
        for (CharsRef s : stems) {
            if (terms.contains(s)) continue;
            deduped.add(s);
            terms.add(s);
        }
        return deduped;
    }

    private CharsRef newStem(char[] buffer, int length) {
        if (this.dictionary.needsOutputCleaning) {
            this.scratchSegment.setLength(0);
            this.scratchSegment.append(buffer, 0, length);
            try {
                Dictionary.applyMappings(this.dictionary.oconv, this.scratchSegment);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
            char[] cleaned = new char[this.scratchSegment.length()];
            this.scratchSegment.getChars(0, cleaned.length, cleaned, 0);
            return new CharsRef(cleaned, 0, cleaned.length);
        }
        return new CharsRef(buffer, 0, length);
    }

    private List<CharsRef> stem(char[] word, int length, int previous, int prevFlag, int prefixFlag, int recursionDepth, boolean doPrefix, boolean doSuffix, boolean previousWasPrefix, boolean circumfix) {
        List<CharsRef> stemList;
        char[] strippedWord;
        int deAffixedLength;
        int stripEnd;
        int stripLength;
        int stripStart;
        boolean compatible;
        char append;
        boolean crossProduct;
        int condition;
        char stripOrd;
        char flag;
        int j;
        int i;
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        if (doPrefix && this.dictionary.prefixes != null) {
            for (i = length - 1; i >= 0; --i) {
                IntsRef prefixes = this.dictionary.lookupPrefix(word, 0, i);
                if (prefixes == null) continue;
                for (j = 0; j < prefixes.length; ++j) {
                    int deAffixedStart;
                    int prefix = prefixes.ints[prefixes.offset + j];
                    if (prefix == previous) continue;
                    this.affixReader.setPosition(8 * prefix);
                    flag = (char)(this.affixReader.readShort() & 0xFFFF);
                    stripOrd = (char)(this.affixReader.readShort() & 0xFFFF);
                    condition = this.affixReader.readShort() & 0xFFFF;
                    crossProduct = (condition & '\u0001') == 1;
                    condition >>>= 1;
                    append = (char)(this.affixReader.readShort() & 0xFFFF);
                    if (recursionDepth == 0) {
                        compatible = true;
                    } else if (crossProduct) {
                        this.dictionary.flagLookup.get(append, this.scratch);
                        char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                        assert (prevFlag >= 0);
                        compatible = this.hasCrossCheckedFlag((char)prevFlag, appendFlags, false);
                    } else {
                        compatible = false;
                    }
                    if (!compatible || !this.checkCondition(condition, this.dictionary.stripData, stripStart = this.dictionary.stripOffsets[stripOrd], stripLength = (stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001']) - stripStart, word, deAffixedStart = i, deAffixedLength = length - deAffixedStart)) continue;
                    strippedWord = new char[stripLength + deAffixedLength];
                    System.arraycopy(this.dictionary.stripData, stripStart, strippedWord, 0, stripLength);
                    System.arraycopy(word, deAffixedStart, strippedWord, stripLength, deAffixedLength);
                    stemList = this.applyAffix(strippedWord, strippedWord.length, prefix, -1, recursionDepth, true, circumfix);
                    stems.addAll(stemList);
                }
            }
        }
        if (doSuffix && this.dictionary.suffixes != null) {
            for (i = 0; i < length; ++i) {
                IntsRef suffixes = this.dictionary.lookupSuffix(word, i, length - i);
                if (suffixes == null) continue;
                for (j = 0; j < suffixes.length; ++j) {
                    int appendLength;
                    int suffix = suffixes.ints[suffixes.offset + j];
                    if (suffix == previous) continue;
                    this.affixReader.setPosition(8 * suffix);
                    flag = (char)(this.affixReader.readShort() & 0xFFFF);
                    stripOrd = (char)(this.affixReader.readShort() & 0xFFFF);
                    condition = (char)(this.affixReader.readShort() & 0xFFFF);
                    crossProduct = (condition & '\u0001') == 1;
                    condition >>>= 1;
                    append = (char)(this.affixReader.readShort() & 0xFFFF);
                    if (recursionDepth == 0) {
                        compatible = true;
                    } else if (crossProduct) {
                        this.dictionary.flagLookup.get(append, this.scratch);
                        char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                        assert (prevFlag >= 0);
                        compatible = this.hasCrossCheckedFlag((char)prevFlag, appendFlags, previousWasPrefix);
                    } else {
                        compatible = false;
                    }
                    if (!compatible || !this.checkCondition(condition, word, 0, deAffixedLength = length - (appendLength = length - i), this.dictionary.stripData, stripStart = this.dictionary.stripOffsets[stripOrd], stripLength = (stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001']) - stripStart)) continue;
                    strippedWord = new char[stripLength + deAffixedLength];
                    System.arraycopy(word, 0, strippedWord, 0, deAffixedLength);
                    System.arraycopy(this.dictionary.stripData, stripStart, strippedWord, deAffixedLength, stripLength);
                    stemList = this.applyAffix(strippedWord, strippedWord.length, suffix, prefixFlag, recursionDepth, false, circumfix);
                    stems.addAll(stemList);
                }
            }
        }
        return stems;
    }

    private boolean checkCondition(int condition, char[] c1, int c1off, int c1len, char[] c2, int c2off, int c2len) {
        if (condition != 0) {
            int i;
            CharacterRunAutomaton pattern = this.dictionary.patterns.get(condition);
            int state = pattern.getInitialState();
            for (i = c1off; i < c1off + c1len; ++i) {
                if ((state = pattern.step(state, c1[i])) != -1) continue;
                return false;
            }
            for (i = c2off; i < c2off + c2len; ++i) {
                if ((state = pattern.step(state, c2[i])) != -1) continue;
                return false;
            }
            return pattern.isAccept(state);
        }
        return true;
    }

    List<CharsRef> applyAffix(char[] strippedWord, int length, int affix, int prefixFlag, int recursionDepth, boolean prefix, boolean circumfix) {
        this.affixReader.setPosition(8 * affix);
        char flag = (char)(this.affixReader.readShort() & 0xFFFF);
        this.affixReader.skipBytes(2L);
        int condition = this.affixReader.readShort() & 0xFFFF;
        boolean crossProduct = (condition & '\u0001') == 1;
        condition >>>= 1;
        char append = (char)(this.affixReader.readShort() & 0xFFFF);
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        IntsRef forms = this.dictionary.lookupWord(strippedWord, 0, length);
        if (forms != null) {
            for (int i = 0; i < forms.length; ++i) {
                char[] appendFlags;
                boolean chainedPrefix;
                this.dictionary.flagLookup.get(forms.ints[forms.offset + i], this.scratch);
                char[] wordFlags = Dictionary.decodeFlags(this.scratch);
                if (!Dictionary.hasFlag(wordFlags, flag)) continue;
                boolean bl = chainedPrefix = this.dictionary.complexPrefixes && recursionDepth == 1 && prefix;
                if (!chainedPrefix && prefixFlag >= 0 && !Dictionary.hasFlag(wordFlags, (char)prefixFlag)) {
                    this.dictionary.flagLookup.get(append, this.scratch);
                    appendFlags = Dictionary.decodeFlags(this.scratch);
                    if (!this.hasCrossCheckedFlag((char)prefixFlag, appendFlags, false)) continue;
                }
                if (this.dictionary.circumfix != -1) {
                    this.dictionary.flagLookup.get(append, this.scratch);
                    appendFlags = Dictionary.decodeFlags(this.scratch);
                    boolean suffixCircumfix = Dictionary.hasFlag(appendFlags, (char)this.dictionary.circumfix);
                    if (circumfix != suffixCircumfix) continue;
                }
                stems.add(this.newStem(strippedWord, length));
            }
        }
        if (this.dictionary.circumfix != -1 && !circumfix && prefix) {
            this.dictionary.flagLookup.get(append, this.scratch);
            char[] appendFlags = Dictionary.decodeFlags(this.scratch);
            circumfix = Dictionary.hasFlag(appendFlags, (char)this.dictionary.circumfix);
        }
        if (crossProduct) {
            if (recursionDepth == 0) {
                if (prefix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, flag, ++recursionDepth, this.dictionary.complexPrefixes && this.dictionary.twoStageAffix, true, true, circumfix));
                } else if (!this.dictionary.complexPrefixes && this.dictionary.twoStageAffix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, prefixFlag, ++recursionDepth, false, true, false, circumfix));
                }
            } else if (recursionDepth == 1) {
                if (prefix && this.dictionary.complexPrefixes) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, flag, ++recursionDepth, false, true, true, circumfix));
                } else if (!prefix && !this.dictionary.complexPrefixes && this.dictionary.twoStageAffix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, prefixFlag, ++recursionDepth, false, true, false, circumfix));
                }
            }
        }
        return stems;
    }

    private boolean hasCrossCheckedFlag(char flag, char[] flags, boolean matchEmpty) {
        return flags.length == 0 && matchEmpty || Arrays.binarySearch(flags, flag) >= 0;
    }
}

