/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

public class RepositoryFilter
implements Filter {
    private final RepositoryResolver<HttpServletRequest> resolver;
    private ServletContext context;

    public RepositoryFilter(RepositoryResolver<HttpServletRequest> resolver) {
        this.resolver = resolver;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    @Override
    public void destroy() {
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Repository db;
        String name;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (request.getAttribute("org.eclipse.jgit.Repository") != null) {
            this.context.log(MessageFormat.format(HttpServerText.get().internalServerErrorRequestAttributeWasAlreadySet, "org.eclipse.jgit.Repository", this.getClass().getName()));
            GitSmartHttpTools.sendError(req, res, 500);
            return;
        }
        for (name = req.getPathInfo(); name != null && 0 < name.length() && name.charAt(0) == '/'; name = name.substring(1)) {
        }
        if (name == null || name.length() == 0) {
            GitSmartHttpTools.sendError(req, res, 404);
            return;
        }
        try {
            db = this.resolver.open(req, name);
        }
        catch (RepositoryNotFoundException e) {
            GitSmartHttpTools.sendError(req, res, 404);
            return;
        }
        catch (ServiceNotEnabledException e) {
            GitSmartHttpTools.sendError(req, res, 403);
            return;
        }
        catch (ServiceNotAuthorizedException e) {
            res.sendError(401);
            return;
        }
        catch (ServiceMayNotContinueException e) {
            GitSmartHttpTools.sendError(req, res, 403, e.getMessage());
            return;
        }
        try {
            request.setAttribute("org.eclipse.jgit.Repository", db);
            chain.doFilter(request, response);
        }
        finally {
            request.removeAttribute("org.eclipse.jgit.Repository");
            db.close();
        }
    }
}

