/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.RefConfigSection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AccessSection
extends RefConfigSection
implements Comparable<AccessSection> {
    public static final String GLOBAL_CAPABILITIES = "GLOBAL_CAPABILITIES";
    protected List<Permission> permissions;

    protected AccessSection() {
    }

    public AccessSection(String refPattern) {
        super(refPattern);
    }

    public List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        return this.permissions;
    }

    public void setPermissions(List<Permission> list) {
        HashSet<String> names = new HashSet<String>();
        for (Permission p : list) {
            if (names.add(p.getName().toLowerCase())) continue;
            throw new IllegalArgumentException();
        }
        this.permissions = list;
    }

    public Permission getPermission(String name) {
        return this.getPermission(name, false);
    }

    public Permission getPermission(String name, boolean create) {
        for (Permission p : this.getPermissions()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        if (create) {
            Permission p = new Permission(name);
            this.permissions.add(p);
            return p;
        }
        return null;
    }

    public void remove(Permission permission) {
        if (permission != null) {
            this.removePermission(permission.getName());
        }
    }

    public void removePermission(String name) {
        if (this.permissions != null) {
            Iterator<Permission> itr = this.permissions.iterator();
            while (itr.hasNext()) {
                if (!name.equalsIgnoreCase(itr.next().getName())) continue;
                itr.remove();
            }
        }
    }

    public void mergeFrom(AccessSection section) {
        for (Permission src : section.getPermissions()) {
            Permission dst = this.getPermission(src.getName());
            if (dst != null) {
                dst.mergeFrom(src);
                continue;
            }
            this.permissions.add(src);
        }
    }

    @Override
    public int compareTo(AccessSection o) {
        return this.comparePattern().compareTo(o.comparePattern());
    }

    private String comparePattern() {
        if (this.getName().startsWith("^")) {
            return this.getName().substring("^".length());
        }
        return this.getName();
    }

    public String toString() {
        return "AccessSection[" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AccessSection)) {
            return false;
        }
        return new HashSet<Permission>(this.getPermissions()).equals(new HashSet<Permission>(((AccessSection)obj).getPermissions()));
    }
}

