/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init;

import com.google.gerrit.pgm.init.AllProjectsNameOnInitProvider;
import com.google.gerrit.pgm.init.InitFlags;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;

public class AllProjectsConfig
extends VersionedMetaData {
    private final String project;
    private final SitePaths site;
    private final InitFlags flags;
    private Config cfg;
    private ObjectId revision;

    @Inject
    AllProjectsConfig(AllProjectsNameOnInitProvider allProjects, SitePaths site, InitFlags flags) {
        this.project = allProjects.get();
        this.site = site;
        this.flags = flags;
    }

    @Override
    protected String getRefName() {
        return "refs/meta/config";
    }

    private File getPath() {
        File basePath = this.site.resolve(this.flags.cfg.getString("gerrit", null, "basePath"));
        if (basePath == null) {
            throw new IllegalStateException("gerrit.basePath must be configured");
        }
        return RepositoryCache.FileKey.resolve(new File(basePath, this.project), FS.DETECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config load() throws IOException, ConfigInvalidException {
        File path = this.getPath();
        if (path == null) {
            return null;
        }
        try (FileRepository repo = new FileRepository(path);){
            this.load(repo);
        }
        return this.cfg;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.cfg = this.readConfig("project.config");
        this.revision = this.getRevision();
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        throw new UnsupportedOperationException();
    }

    void save(String message) throws IOException {
        this.save(new PersonIdent("Gerrit Initialization", "init@gerrit"), message);
    }

    public void save(String pluginName, String message) throws IOException {
        this.save(new PersonIdent(pluginName, pluginName + "@gerrit"), "Update from plugin " + pluginName + ": " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(PersonIdent ident, String msg) throws IOException {
        File path = this.getPath();
        if (path == null) {
            throw new IOException("All-Projects does not exist.");
        }
        try (FileRepository repo = new FileRepository(path);){
            this.inserter = repo.newObjectInserter();
            this.reader = repo.newObjectReader();
            try (RevWalk rw = new RevWalk(this.reader);){
                RevTree srcTree = this.revision != null ? rw.parseTree(this.revision) : null;
                this.newTree = this.readTree(srcTree);
                this.saveConfig("project.config", this.cfg);
                ObjectId res = this.newTree.writeTree(this.inserter);
                if (res.equals(srcTree)) {
                    return;
                }
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(ident);
                commit.setCommitter(ident);
                commit.setMessage(msg);
                commit.setTreeId(res);
                if (this.revision != null) {
                    commit.addParentId(this.revision);
                }
                ObjectId newRevision = this.inserter.insert(commit);
                this.updateRef(repo, ident, newRevision, "commit: " + msg);
                this.revision = newRevision;
            }
            finally {
                if (this.inserter != null) {
                    this.inserter.close();
                    this.inserter = null;
                }
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
            }
        }
    }

    private void updateRef(Repository repo, PersonIdent ident, ObjectId newRevision, String refLogMsg) throws IOException {
        RefUpdate ru = repo.updateRef(this.getRefName());
        ru.setRefLogIdent(ident);
        ru.setNewObjectId(newRevision);
        ru.setExpectedOldObjectId(this.revision);
        ru.setRefLogMessage(refLogMsg, false);
        RefUpdate.Result r = ru.update();
        switch (r) {
            case FAST_FORWARD: 
            case NEW: 
            case NO_CHANGE: {
                break;
            }
            default: {
                throw new IOException("Failed to update " + this.getRefName() + " of " + this.project + ": " + r.name());
            }
        }
    }
}

