/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.pgm.init.InitFlags;
import com.google.gerrit.pgm.util.ConsoleUI;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class Section {
    private final InitFlags flags;
    private final SitePaths site;
    private final ConsoleUI ui;
    private final String section;
    private final String subsection;

    @Inject
    public Section(InitFlags flags, SitePaths site, ConsoleUI ui, @Assisted(value="section") String section, @Assisted(value="subsection") @Nullable String subsection) {
        this.flags = flags;
        this.site = site;
        this.ui = ui;
        this.section = section;
        this.subsection = subsection;
    }

    String get(String name) {
        return this.flags.cfg.getString(this.section, this.subsection, name);
    }

    public void set(String name, String value) {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(this.flags.cfg.getStringList(this.section, this.subsection, name)));
        if (value != null) {
            if (all.size() == 0 || all.size() == 1) {
                this.flags.cfg.setString(this.section, this.subsection, name, value);
            } else {
                all.set(0, value);
                this.flags.cfg.setStringList(this.section, this.subsection, name, all);
            }
        } else if (all.size() != 0) {
            if (all.size() == 1) {
                this.flags.cfg.unset(this.section, this.subsection, name);
            } else {
                all.remove(0);
                this.flags.cfg.setStringList(this.section, this.subsection, name, all);
            }
        }
    }

    public <T extends Enum<?>> void set(String name, T value) {
        if (value != null) {
            this.set(name, value.name());
        } else {
            this.unset(name);
        }
    }

    public void unset(String name) {
        this.set(name, (String)null);
    }

    public String string(String title, String name, String dv) {
        return this.string(title, name, dv, false);
    }

    public String string(String title, String name, String dv, boolean nullIfDefault) {
        String ov = this.get(name);
        String nv = this.ui.readString(ov != null ? ov : dv, "%s", title);
        if (nullIfDefault && nv.equals(dv)) {
            nv = null;
        }
        if (!Section.eq(ov, nv)) {
            this.set(name, nv);
        }
        return nv;
    }

    public File path(String title, String name, String defValue) {
        return this.site.resolve(this.string(title, name, defValue));
    }

    public <T extends Enum<?>> T select(String title, String name, T defValue) {
        return this.select(title, name, defValue, false);
    }

    public <T extends Enum<?>> T select(String title, String name, T defValue, boolean nullIfDefault) {
        boolean set = this.get(name) != null;
        T oldValue = ConfigUtil.getEnum(this.flags.cfg, this.section, this.subsection, name, defValue);
        T newValue = this.ui.readEnum(oldValue, "%s", title);
        if (nullIfDefault && newValue == defValue) {
            newValue = null;
        }
        if (!set || oldValue != newValue) {
            if (newValue != null) {
                this.set(name, newValue);
            } else {
                this.unset(name);
            }
        }
        return newValue;
    }

    public String select(String title, String name, String dv, Set<String> allowedValues) {
        String ov;
        String nv = this.ui.readString((ov = this.get(name)) != null ? ov : dv, allowedValues, "%s", title);
        if (!Section.eq(ov, nv)) {
            this.set(name, nv);
        }
        return nv;
    }

    public String password(String username, String password) {
        String ov = this.getSecure(password);
        String user = this.flags.sec.getString(this.section, this.subsection, username);
        if (user == null) {
            user = this.get(username);
        }
        if (user == null) {
            this.flags.sec.unset(this.section, this.subsection, password);
            return null;
        }
        if (ov != null && (this.ui.isBatch() || !this.ui.yesno(false, "Change %s's password", user))) {
            return ov;
        }
        String nv = this.ui.password("%s's password", user);
        if (!Section.eq(ov, nv)) {
            this.setSecure(password, nv);
        }
        return nv;
    }

    public String passwordForKey(String key, String password) {
        String ov = this.getSecure(password);
        if (ov != null && (this.ui.isBatch() || !this.ui.yesno(false, "Change %s", key))) {
            return ov;
        }
        String nv = this.ui.password("%s", key);
        if (!Section.eq(ov, nv)) {
            this.setSecure(password, nv);
        }
        return nv;
    }

    public String getSecure(String name) {
        return this.flags.sec.getString(this.section, this.subsection, name);
    }

    public void setSecure(String name, String value) {
        if (value != null) {
            this.flags.sec.setString(this.section, this.subsection, name, value);
        } else {
            this.flags.sec.unset(this.section, this.subsection, name);
        }
    }

    String getName() {
        return this.section;
    }

    private static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && a.equals(b);
    }

    public static interface Factory {
        public Section get(@Assisted(value="section") String var1, @Assisted(value="subsection") String var2);
    }
}

