/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;

@Singleton
public class PutHttpPassword
implements RestModifyView<AccountResource, Input> {
    private static final int LEN = 31;
    private static final SecureRandom rng;
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache accountCache;

    @Inject
    PutHttpPassword(Provider<CurrentUser> self, Provider<ReviewDb> dbProvider, AccountCache accountCache) {
        this.self = self;
        this.dbProvider = dbProvider;
        this.accountCache = accountCache;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, OrmException {
        String newPassword;
        if (input == null) {
            input = new Input();
        }
        input.httpPassword = Strings.emptyToNull(input.httpPassword);
        if (input.generate) {
            if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canGenerateHttpPassword()) {
                throw new AuthException("not allowed to generate HTTP password");
            }
            newPassword = PutHttpPassword.generate();
        } else if (input.httpPassword == null) {
            if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
                throw new AuthException("not allowed to clear HTTP password");
            }
            newPassword = null;
        } else {
            if (!this.self.get().getCapabilities().canAdministrateServer()) {
                throw new AuthException("not allowed to set HTTP password directly, need to be Gerrit administrator");
            }
            newPassword = input.httpPassword;
        }
        return this.apply(rsrc.getUser(), newPassword);
    }

    public Response<String> apply(IdentifiedUser user, String newPassword) throws ResourceNotFoundException, ResourceConflictException, OrmException {
        if (user.getUserName() == null) {
            throw new ResourceConflictException("username must be set");
        }
        AccountExternalId id = this.dbProvider.get().accountExternalIds().get(new AccountExternalId.Key("username:", user.getUserName()));
        if (id == null) {
            throw new ResourceNotFoundException();
        }
        id.setPassword(newPassword);
        this.dbProvider.get().accountExternalIds().update(Collections.singleton(id));
        this.accountCache.evict(user.getAccountId());
        return Strings.isNullOrEmpty(newPassword) ? Response.none() : Response.ok(newPassword);
    }

    private static String generate() {
        byte[] rand = new byte[31];
        rng.nextBytes(rand);
        byte[] enc = Base64.encodeBase64(rand, false);
        StringBuilder r = new StringBuilder(enc.length);
        for (int i = 0; i < enc.length && enc[i] != 61; ++i) {
            r.append((char)enc[i]);
        }
        return r.toString();
    }

    static {
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create RNG for password generator", e);
        }
    }

    public static class Input {
        public String httpPassword;
        public boolean generate;
    }
}

