/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UniversalGroupBackend
implements GroupBackend {
    private static final Logger log = LoggerFactory.getLogger(UniversalGroupBackend.class);
    private final DynamicSet<GroupBackend> backends;

    @Inject
    UniversalGroupBackend(DynamicSet<GroupBackend> backends) {
        this.backends = backends;
    }

    @Nullable
    private GroupBackend backend(AccountGroup.UUID uuid) {
        if (uuid != null) {
            for (GroupBackend g : this.backends) {
                if (!g.handles(uuid)) continue;
                return g;
            }
        }
        return null;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return this.backend(uuid) != null;
    }

    @Override
    public GroupDescription.Basic get(AccountGroup.UUID uuid) {
        GroupBackend b = this.backend(uuid);
        if (b == null) {
            log.warn("Unknown GroupBackend for UUID: " + uuid);
            return null;
        }
        return b.get(uuid);
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectControl project) {
        TreeSet<GroupReference> groups = Sets.newTreeSet(GroupBackends.GROUP_REF_NAME_COMPARATOR);
        for (GroupBackend g : this.backends) {
            groups.addAll(g.suggest(name, project));
        }
        return groups;
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return new UniversalGroupMembership(user);
    }

    private class UniversalGroupMembership
    implements GroupMembership {
        private final Map<GroupBackend, GroupMembership> memberships;

        private UniversalGroupMembership(IdentifiedUser user) {
            ImmutableMap.Builder<GroupBackend, GroupMembership> builder = ImmutableMap.builder();
            for (GroupBackend g : UniversalGroupBackend.this.backends) {
                builder.put(g, g.membershipsOf(user));
            }
            this.memberships = builder.build();
        }

        @Nullable
        private GroupMembership membership(AccountGroup.UUID uuid) {
            if (uuid != null) {
                for (Map.Entry<GroupBackend, GroupMembership> m : this.memberships.entrySet()) {
                    if (!m.getKey().handles(uuid)) continue;
                    return m.getValue();
                }
            }
            return null;
        }

        @Override
        public boolean contains(AccountGroup.UUID uuid) {
            GroupMembership m = this.membership(uuid);
            if (m == null) {
                log.warn("Unknown GroupMembership for UUID: " + uuid);
                return false;
            }
            return m.contains(uuid);
        }

        @Override
        public boolean containsAnyOf(Iterable<AccountGroup.UUID> uuids) {
            GroupMembership m;
            ArrayListMultimap<GroupMembership, AccountGroup.UUID> lookups = ArrayListMultimap.create();
            for (AccountGroup.UUID uUID : uuids) {
                m = this.membership(uUID);
                if (m == null) {
                    log.warn("Unknown GroupMembership for UUID: " + uUID);
                    continue;
                }
                lookups.put(m, uUID);
            }
            for (Map.Entry entry : lookups.asMap().entrySet()) {
                m = (GroupMembership)entry.getKey();
                Collection ids = (Collection)entry.getValue();
                if (!(ids.size() == 1 ? m.contains((AccountGroup.UUID)Iterables.getOnlyElement(ids)) : m.containsAnyOf(ids))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<AccountGroup.UUID> intersection(Iterable<AccountGroup.UUID> uuids) {
            ArrayListMultimap<GroupMembership, AccountGroup.UUID> lookups = ArrayListMultimap.create();
            for (AccountGroup.UUID uuid : uuids) {
                GroupMembership m = this.membership(uuid);
                if (m == null) {
                    log.warn("Unknown GroupMembership for UUID: " + uuid);
                    continue;
                }
                lookups.put(m, uuid);
            }
            HashSet<AccountGroup.UUID> groups = Sets.newHashSet();
            for (Map.Entry entry : lookups.asMap().entrySet()) {
                groups.addAll(((GroupMembership)entry.getKey()).intersection(entry.getValue()));
            }
            return groups;
        }

        @Override
        public Set<AccountGroup.UUID> getKnownGroups() {
            HashSet<AccountGroup.UUID> groups = Sets.newHashSet();
            for (GroupMembership m : this.memberships.values()) {
                groups.addAll(m.getKnownGroups());
            }
            return groups;
        }
    }
}

