/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.accounts;

import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.api.accounts.Accounts;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.api.accounts.AccountApiImpl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class AccountsImpl
extends Accounts.NotImplemented
implements Accounts {
    private final AccountsCollection accounts;
    private final AccountApiImpl.Factory api;
    private final Provider<CurrentUser> self;

    @Inject
    AccountsImpl(AccountsCollection accounts, AccountApiImpl.Factory api, Provider<CurrentUser> self) {
        this.accounts = accounts;
        this.api = api;
        this.self = self;
    }

    @Override
    public AccountApi id(String id) throws RestApiException {
        try {
            return this.api.create(this.accounts.parse(TopLevelResource.INSTANCE, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse change", e);
        }
    }

    @Override
    public AccountApi self() throws RestApiException {
        if (!this.self.get().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.api.create(new AccountResource((IdentifiedUser)this.self.get()));
    }
}

