/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.change.ChangeKind;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeKindCacheImpl
implements ChangeKindCache {
    private static final Logger log = LoggerFactory.getLogger(ChangeKindCacheImpl.class);
    private static final String ID_CACHE = "change_kind";
    private final LoadingCache<Key, ChangeKind> cache;
    private final boolean useRecursiveMerge;
    private final ChangeData.Factory changeDataFactory;
    private final ProjectCache projectCache;
    private final GitRepositoryManager repoManager;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.bind(ChangeKindCache.class).to(ChangeKindCacheImpl.class);
                this.persist(ChangeKindCacheImpl.ID_CACHE, Key.class, ChangeKind.class).maximumWeight(0x200000L).weigher(ChangeKindWeigher.class).loader(Loader.class);
            }
        };
    }

    @Inject
    ChangeKindCacheImpl(@GerritServerConfig Config serverConfig, @Named(value="change_kind") LoadingCache<Key, ChangeKind> cache, ChangeData.Factory changeDataFactory, ProjectCache projectCache, GitRepositoryManager repoManager) {
        this.cache = cache;
        this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
        this.changeDataFactory = changeDataFactory;
        this.projectCache = projectCache;
        this.repoManager = repoManager;
    }

    @Override
    public ChangeKind getChangeKind(ProjectState project, Repository repo, ObjectId prior, ObjectId next) {
        try {
            return this.cache.get(new Key(repo, prior, next, this.useRecursiveMerge));
        }
        catch (ExecutionException e) {
            log.warn("Cannot check trivial rebase of new patch set " + next.name() + " in " + project.getProject().getName(), e);
            return ChangeKind.REWORK;
        }
    }

    @Override
    public ChangeKind getChangeKind(ReviewDb db, Change change, PatchSet patch) {
        return ChangeKindCacheImpl.getChangeKindInternal(this, db, change, patch, this.changeDataFactory, this.projectCache, this.repoManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChangeKind getChangeKindInternal(ChangeKindCache cache, ReviewDb db, Change change, PatchSet patch, ChangeData.Factory changeDataFactory, ProjectCache projectCache, GitRepositoryManager repoManager) {
        Repository repo = null;
        ChangeKind kind = ChangeKind.REWORK;
        if (patch.getId().get() > 1) {
            try {
                ProjectState projectState = projectCache.checkedGet(change.getProject());
                repo = repoManager.openRepository(change.getProject());
                ChangeData cd = changeDataFactory.create(db, change);
                Collection<PatchSet> patchSetCollection = cd.patches();
                PatchSet priorPs = patch;
                for (PatchSet ps : patchSetCollection) {
                    if (ps.getId().get() >= patch.getId().get() || ps.getId().get() <= priorPs.getId().get() && priorPs != patch) continue;
                    priorPs = ps;
                }
                if (priorPs != patch) {
                    kind = cache.getChangeKind(projectState, repo, ObjectId.fromString(priorPs.getRevision().get()), ObjectId.fromString(patch.getRevision().get()));
                }
            }
            catch (OrmException | IOException e) {
                log.warn("Unable to get change kind for patchSet " + patch.getPatchSetId() + "of change " + change.getChangeId(), e);
            }
            finally {
                if (repo != null) {
                    repo.close();
                }
            }
        }
        return kind;
    }

    public static class ChangeKindWeigher
    implements Weigher<Key, ChangeKind> {
        @Override
        public int weigh(Key key, ChangeKind changeKind) {
            return 88 + 2 * key.strategyName.length() + 2 * changeKind.name().length();
        }
    }

    @Singleton
    private static class Loader
    extends CacheLoader<Key, ChangeKind> {
        private Loader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChangeKind load(Key key) throws IOException {
            if (Objects.equal(key.prior, key.next)) {
                return ChangeKind.NO_CODE_CHANGE;
            }
            RevWalk walk = new RevWalk(key.repo);
            try {
                RevCommit prior = walk.parseCommit(key.prior);
                walk.parseBody(prior);
                RevCommit next = walk.parseCommit(key.next);
                walk.parseBody(next);
                if (!next.getFullMessage().equals(prior.getFullMessage())) {
                    if (next.getTree() == prior.getTree() && Loader.isSameParents(prior, next)) {
                        ChangeKind changeKind = ChangeKind.NO_CODE_CHANGE;
                        return changeKind;
                    }
                    ChangeKind changeKind = ChangeKind.REWORK;
                    return changeKind;
                }
                if (prior.getParentCount() != 1 || next.getParentCount() != 1) {
                    ChangeKind changeKind = ChangeKind.REWORK;
                    return changeKind;
                }
                if (next.getTree() == prior.getTree() && Loader.isSameParents(prior, next)) {
                    ChangeKind changeKind = ChangeKind.TRIVIAL_REBASE;
                    return changeKind;
                }
                ThreeWayMerger merger = MergeUtil.newThreeWayMerger(key.repo, MergeUtil.createDryRunInserter(key.repo), key.strategyName);
                merger.setBase(prior.getParent(0));
                if (merger.merge(next.getParent(0), prior) && merger.getResultTreeId().equals(next.getTree())) {
                    ChangeKind changeKind = ChangeKind.TRIVIAL_REBASE;
                    return changeKind;
                }
                ChangeKind changeKind = ChangeKind.REWORK;
                return changeKind;
            }
            finally {
                key.repo = null;
                walk.close();
            }
        }

        private static boolean isSameParents(RevCommit prior, RevCommit next) {
            if (prior.getParentCount() != next.getParentCount()) {
                return false;
            }
            if (prior.getParentCount() == 0) {
                return true;
            }
            return prior.getParent(0).equals(next.getParent(0));
        }
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient ObjectId prior;
        private transient ObjectId next;
        private transient String strategyName;
        private transient Repository repo;

        private Key(Repository repo, ObjectId prior, ObjectId next, boolean useRecursiveMerge) {
            Preconditions.checkNotNull(next, "next");
            String strategyName = MergeUtil.mergeStrategyName(true, useRecursiveMerge);
            this.prior = prior.copy();
            this.next = next.copy();
            this.strategyName = strategyName;
            this.repo = repo;
        }

        public Key(ObjectId prior, ObjectId next, String strategyName) {
            this.prior = prior;
            this.next = next;
            this.strategyName = strategyName;
        }

        public ObjectId getPrior() {
            return this.prior;
        }

        public ObjectId getNext() {
            return this.next;
        }

        public String getStrategyName() {
            return this.strategyName;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return Objects.equal(this.prior, k.prior) && Objects.equal(this.next, k.next) && Objects.equal(this.strategyName, k.strategyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.prior, this.next, this.strategyName);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            ObjectIdSerialization.writeNotNull(out, this.prior);
            ObjectIdSerialization.writeNotNull(out, this.next);
            out.writeUTF(this.strategyName);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.prior = ObjectIdSerialization.readNotNull(in);
            this.next = ObjectIdSerialization.readNotNull(in);
            this.strategyName = in.readUTF();
        }
    }

    @VisibleForTesting
    public static class NoCache
    implements ChangeKindCache {
        private final boolean useRecursiveMerge;
        private final ChangeData.Factory changeDataFactory;
        private final ProjectCache projectCache;
        private final GitRepositoryManager repoManager;

        @Inject
        NoCache(@GerritServerConfig Config serverConfig, ChangeData.Factory changeDataFactory, ProjectCache projectCache, GitRepositoryManager repoManager) {
            this.useRecursiveMerge = MergeUtil.useRecursiveMerge(serverConfig);
            this.changeDataFactory = changeDataFactory;
            this.projectCache = projectCache;
            this.repoManager = repoManager;
        }

        @Override
        public ChangeKind getChangeKind(ProjectState project, Repository repo, ObjectId prior, ObjectId next) {
            try {
                return new Loader().load(new Key(repo, prior, next, this.useRecursiveMerge));
            }
            catch (IOException e) {
                log.warn("Cannot check trivial rebase of new patch set " + next.name() + " in " + project.getProject().getName(), e);
                return ChangeKind.REWORK;
            }
        }

        @Override
        public ChangeKind getChangeKind(ReviewDb db, Change change, PatchSet patch) {
            return ChangeKindCacheImpl.getChangeKindInternal(this, db, change, patch, this.changeDataFactory, this.projectCache, this.repoManager);
        }
    }
}

