/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ProjectUtil;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.git.MergeQueue;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;

@Singleton
public class Submit
implements RestModifyView<RevisionResource, SubmitInput>,
UiAction<RevisionResource> {
    private static final String DEFAULT_TOOLTIP = "Submit patch set ${patchSet} into ${branch}";
    private final PersonIdent serverIdent;
    private final Provider<ReviewDb> dbProvider;
    private final GitRepositoryManager repoManager;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ChangeUpdate.Factory updateFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final MergeQueue mergeQueue;
    private final ChangeIndexer indexer;
    private final LabelNormalizer labelNormalizer;
    private final AccountsCollection accounts;
    private final ChangesCollection changes;
    private final String label;
    private final ParameterizedString titlePattern;

    @Inject
    Submit(@GerritPersonIdent PersonIdent serverIdent, Provider<ReviewDb> dbProvider, GitRepositoryManager repoManager, IdentifiedUser.GenericFactory userFactory, ChangeUpdate.Factory updateFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, MergeQueue mergeQueue, AccountsCollection accounts, ChangesCollection changes, ChangeIndexer indexer, LabelNormalizer labelNormalizer, @GerritServerConfig Config cfg) {
        this.serverIdent = serverIdent;
        this.dbProvider = dbProvider;
        this.repoManager = repoManager;
        this.userFactory = userFactory;
        this.updateFactory = updateFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.mergeQueue = mergeQueue;
        this.accounts = accounts;
        this.changes = changes;
        this.indexer = indexer;
        this.labelNormalizer = labelNormalizer;
        this.label = Objects.firstNonNull(Strings.emptyToNull(cfg.getString("change", null, "submitLabel")), "Submit");
        this.titlePattern = new ParameterizedString(Objects.firstNonNull(cfg.getString("change", null, "submitTooltip"), DEFAULT_TOOLTIP));
    }

    public Output apply(RevisionResource rsrc, SubmitInput input) throws AuthException, ResourceConflictException, RepositoryNotFoundException, IOException, OrmException, UnprocessableEntityException {
        input.onBehalfOf = Strings.emptyToNull(input.onBehalfOf);
        if (input.onBehalfOf != null) {
            rsrc = this.onBehalfOf(rsrc, input);
        }
        ChangeControl control = rsrc.getControl();
        IdentifiedUser caller = (IdentifiedUser)control.getCurrentUser();
        Change change = rsrc.getChange();
        if (input.onBehalfOf == null && !control.canSubmit()) {
            throw new AuthException("submit not permitted");
        }
        if (!change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + Submit.status(change));
        }
        if (!ProjectUtil.branchExists(this.repoManager, change.getDest())) {
            throw new ResourceConflictException(String.format("destination branch \"%s\" not found.", change.getDest().get()));
        }
        if (!rsrc.getPatchSet().getId().equals(change.currentPatchSetId())) {
            throw new ResourceConflictException(String.format("revision %s is not current revision", rsrc.getPatchSet().getRevision().get()));
        }
        change = this.submit(rsrc, caller, false);
        if (change == null) {
            throw new ResourceConflictException("change is " + Submit.status(this.dbProvider.get().changes().get(rsrc.getChange().getId())));
        }
        if (input.waitForMerge) {
            this.mergeQueue.merge(change.getDest());
            change = this.dbProvider.get().changes().get(change.getId());
        } else {
            this.mergeQueue.schedule(change.getDest());
        }
        if (change == null) {
            throw new ResourceConflictException("change is deleted");
        }
        switch (change.getStatus()) {
            case SUBMITTED: {
                return new Output(Status.SUBMITTED, change);
            }
            case MERGED: {
                return new Output(Status.MERGED, change);
            }
            case NEW: {
                ChangeMessage msg = this.getConflictMessage(rsrc);
                if (msg == null) break;
                throw new ResourceConflictException(msg.getMessage());
            }
        }
        throw new ResourceConflictException("change is " + Submit.status(change));
    }

    @Override
    public UiAction.Description getDescription(RevisionResource resource) {
        PatchSet.Id current = resource.getChange().currentPatchSetId();
        RevId revId = resource.getPatchSet().getRevision();
        ImmutableMap<String, String> params = ImmutableMap.of("patchSet", String.valueOf(resource.getPatchSet().getPatchSetId()), "branch", resource.getChange().getDest().getShortName(), "commit", ObjectId.fromString(revId.get()).abbreviate(7).name());
        return new UiAction.Description().setLabel(this.label).setTitle(Strings.emptyToNull(this.titlePattern.replace(params))).setVisible(!resource.getPatchSet().isDraft() && resource.getChange().getStatus().isOpen() && resource.getPatchSet().getId().equals(current) && resource.getControl().canSubmit());
    }

    public ChangeMessage getConflictMessage(RevisionResource rsrc) throws OrmException {
        return FluentIterable.from(this.cmUtil.byPatchSet(this.dbProvider.get(), rsrc.getNotes(), rsrc.getPatchSet().getId())).filter(new Predicate<ChangeMessage>(){

            @Override
            public boolean apply(ChangeMessage input) {
                return input.getAuthor() == null;
            }
        }).last().orNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change submit(RevisionResource rsrc, IdentifiedUser caller, boolean force) throws ResourceConflictException, OrmException, IOException {
        List<SubmitRecord> submitRecords = this.checkSubmitRule(rsrc, force);
        final Timestamp timestamp = TimeUtil.nowTs();
        Change change = rsrc.getChange();
        ChangeUpdate update = this.updateFactory.create(rsrc.getControl(), timestamp);
        update.submit(submitRecords);
        ReviewDb db = this.dbProvider.get();
        db.changes().beginTransaction(change.getId());
        try {
            VersionedMetaData.BatchMetaDataUpdate batch = this.approve(rsrc, update, caller, timestamp);
            batch.write(update, new CommitBuilder());
            change = db.changes().atomicUpdate(change.getId(), new AtomicUpdate<Change>(){

                @Override
                public Change update(Change change) {
                    if (change.getStatus().isOpen()) {
                        change.setStatus(Change.Status.SUBMITTED);
                        change.setLastUpdatedOn(timestamp);
                        ChangeUtil.computeSortKey(change);
                        return change;
                    }
                    return null;
                }
            });
            if (change == null) {
                Change change2 = null;
                return change2;
            }
            db.commit();
        }
        finally {
            db.rollback();
        }
        this.indexer.index(db, change);
        return change;
    }

    private VersionedMetaData.BatchMetaDataUpdate approve(RevisionResource rsrc, ChangeUpdate update, IdentifiedUser caller, Timestamp timestamp) throws OrmException {
        PatchSet.Id psId = rsrc.getPatchSet().getId();
        HashMap<PatchSetApproval.Key, PatchSetApproval> byKey = Maps.newHashMap();
        for (PatchSetApproval psa : this.approvalsUtil.byPatchSet(this.dbProvider.get(), rsrc.getControl(), psId)) {
            if (byKey.containsKey(psa.getKey())) continue;
            byKey.put(psa.getKey(), psa);
        }
        PatchSetApproval submit = ApprovalsUtil.getSubmitter(psId, byKey.values());
        if (submit == null || submit.getAccountId() != caller.getAccountId()) {
            submit = new PatchSetApproval(new PatchSetApproval.Key(rsrc.getPatchSet().getId(), caller.getAccountId(), PatchSetApproval.LabelId.SUBMIT), 1, TimeUtil.nowTs());
            byKey.put(submit.getKey(), submit);
        }
        submit.setValue((short)1);
        submit.setGranted(timestamp);
        LabelNormalizer.Result normalized = this.labelNormalizer.normalize(rsrc.getControl(), byKey.values());
        update.putApproval(submit.getLabel(), submit.getValue());
        this.dbProvider.get().patchSetApprovals().upsert(normalized.getNormalized());
        this.dbProvider.get().patchSetApprovals().delete(normalized.getDeleted());
        try {
            return this.saveToBatch(rsrc, update, normalized, timestamp);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    private VersionedMetaData.BatchMetaDataUpdate saveToBatch(RevisionResource rsrc, ChangeUpdate callerUpdate, LabelNormalizer.Result normalized, Timestamp timestamp) throws IOException {
        HashBasedTable byUser = HashBasedTable.create();
        for (PatchSetApproval psa : normalized.getUpdated()) {
            byUser.put(psa.getAccountId(), psa.getLabel(), Optional.of(psa.getValue()));
        }
        for (PatchSetApproval psa : normalized.getDeleted()) {
            byUser.put(psa.getAccountId(), psa.getLabel(), Optional.absent());
        }
        ChangeControl ctl = rsrc.getControl();
        VersionedMetaData.BatchMetaDataUpdate batch = callerUpdate.openUpdate();
        for (Account.Id accountId : byUser.rowKeySet()) {
            if (accountId.equals(callerUpdate.getUser().getAccountId())) continue;
            ChangeUpdate update = this.updateFactory.create(ctl.forUser(this.userFactory.create(this.dbProvider, accountId)), timestamp);
            update.setSubject("Finalize approvals at submit");
            Submit.putApprovals(update, byUser.row(accountId));
            CommitBuilder commit = new CommitBuilder();
            commit.setCommitter(new PersonIdent(this.serverIdent, timestamp));
            batch.write(update, commit);
        }
        Submit.putApprovals(callerUpdate, byUser.row(callerUpdate.getUser().getAccountId()));
        return batch;
    }

    private static void putApprovals(ChangeUpdate update, Map<String, Optional<Short>> approvals) {
        for (Map.Entry<String, Optional<Short>> e : approvals.entrySet()) {
            if (e.getValue().isPresent()) {
                update.putApproval(e.getKey(), e.getValue().get());
                continue;
            }
            update.removeApproval(e.getKey());
        }
    }

    private List<SubmitRecord> checkSubmitRule(RevisionResource rsrc, boolean force) throws ResourceConflictException {
        List<SubmitRecord> results = rsrc.getControl().canSubmit(this.dbProvider.get(), rsrc.getPatchSet());
        Optional<SubmitRecord> ok = Submit.findOkRecord(results);
        if (ok.isPresent()) {
            return ImmutableList.of(ok.get());
        }
        if (force) {
            return results;
        }
        if (results.isEmpty()) {
            throw new IllegalStateException(String.format("ChangeControl.canSubmit returned empty list for %s in %s", rsrc.getPatchSet().getId(), rsrc.getChange().getProject().get()));
        }
        Iterator<SubmitRecord> i$ = results.iterator();
        if (i$.hasNext()) {
            SubmitRecord record = i$.next();
            switch (record.status) {
                case CLOSED: {
                    throw new ResourceConflictException("change is closed");
                }
                case RULE_ERROR: {
                    throw new ResourceConflictException(String.format("rule error: %s", record.errorMessage));
                }
                case NOT_READY: {
                    StringBuilder msg = new StringBuilder();
                    block11: for (SubmitRecord.Label lbl : record.labels) {
                        switch (lbl.status) {
                            case OK: 
                            case MAY: {
                                continue block11;
                            }
                            case REJECT: {
                                if (msg.length() > 0) {
                                    msg.append("; ");
                                }
                                msg.append("blocked by ").append(lbl.label);
                                continue block11;
                            }
                            case NEED: {
                                if (msg.length() > 0) {
                                    msg.append("; ");
                                }
                                msg.append("needs ").append(lbl.label);
                                continue block11;
                            }
                            case IMPOSSIBLE: {
                                if (msg.length() > 0) {
                                    msg.append("; ");
                                }
                                msg.append("needs ").append(lbl.label).append(" (check project access)");
                                continue block11;
                            }
                        }
                        throw new IllegalStateException(String.format("Unsupported SubmitRecord.Label %s for %s in %s", lbl.toString(), rsrc.getPatchSet().getId(), rsrc.getChange().getProject().get()));
                    }
                    throw new ResourceConflictException(msg.toString());
                }
            }
            throw new IllegalStateException(String.format("Unsupported SubmitRecord %s for %s in %s", record, rsrc.getPatchSet().getId(), rsrc.getChange().getProject().get()));
        }
        throw new IllegalStateException();
    }

    private static Optional<SubmitRecord> findOkRecord(Collection<SubmitRecord> in) {
        return Iterables.tryFind(in, new Predicate<SubmitRecord>(){

            @Override
            public boolean apply(SubmitRecord input) {
                return input.status == SubmitRecord.Status.OK;
            }
        });
    }

    static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }

    private RevisionResource onBehalfOf(RevisionResource rsrc, SubmitInput in) throws AuthException, UnprocessableEntityException, OrmException {
        ChangeControl caller = rsrc.getControl();
        if (!caller.canSubmit()) {
            throw new AuthException("submit not permitted");
        }
        if (!caller.canSubmitAs()) {
            throw new AuthException("submit on behalf of not permitted");
        }
        IdentifiedUser targetUser = this.accounts.parseId(in.onBehalfOf);
        if (targetUser == null) {
            throw new UnprocessableEntityException(String.format("Account Not Found: %s", in.onBehalfOf));
        }
        ChangeControl target = caller.forUser(targetUser);
        if (!target.getRefControl().isVisible()) {
            throw new UnprocessableEntityException(String.format("on_behalf_of account %s cannot see destination ref", targetUser.getAccountId()));
        }
        return new RevisionResource(this.changes.parse(target), rsrc.getPatchSet());
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, SubmitInput> {
        private final Provider<ReviewDb> dbProvider;
        private final Submit submit;
        private final ChangeJson json;

        @Inject
        CurrentRevision(Provider<ReviewDb> dbProvider, Submit submit, ChangeJson json) {
            this.dbProvider = dbProvider;
            this.submit = submit;
            this.json = json;
        }

        public ChangeJson.ChangeInfo apply(ChangeResource rsrc, SubmitInput input) throws AuthException, ResourceConflictException, RepositoryNotFoundException, IOException, OrmException, UnprocessableEntityException {
            PatchSet ps = this.dbProvider.get().patchSets().get(rsrc.getChange().currentPatchSetId());
            if (ps == null) {
                throw new ResourceConflictException("current revision is missing");
            }
            if (!rsrc.getControl().isPatchVisible(ps, this.dbProvider.get())) {
                throw new AuthException("current revision not accessible");
            }
            Output out = this.submit.apply(new RevisionResource(rsrc, ps), input);
            return this.json.format(out.change);
        }
    }

    public static class Output {
        public Status status;
        transient Change change;

        private Output(Status s, Change c) {
            this.status = s;
            this.change = c;
        }
    }

    public static enum Status {
        SUBMITTED,
        MERGED;

    }
}

