/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class BranchOrderSection {
    private final ImmutableList<String> order;

    public BranchOrderSection(String[] order) {
        if (order.length == 0) {
            this.order = ImmutableList.of();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String b : order) {
                builder.add(BranchOrderSection.fullName(b));
            }
            this.order = builder.build();
        }
    }

    private static String fullName(String branch) {
        if (branch.startsWith("refs/heads/")) {
            return branch;
        }
        return "refs/heads/" + branch;
    }

    public List<String> getMoreStable(String branch) {
        int i = this.order.indexOf(BranchOrderSection.fullName(branch));
        if (0 <= i) {
            return this.order.subList(i + 1, this.order.size());
        }
        return ImmutableList.of();
    }
}

