/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.TagMatcher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectIdSerialization;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TagSet {
    private static final Logger log = LoggerFactory.getLogger(TagSet.class);
    private final Project.NameKey projectName;
    private final Map<String, CachedRef> refs;
    private final ObjectIdOwnerMap<Tag> tags;

    TagSet(Project.NameKey projectName) {
        this.projectName = projectName;
        this.refs = new HashMap<String, CachedRef>();
        this.tags = new ObjectIdOwnerMap();
    }

    Tag lookupTag(AnyObjectId id) {
        return this.tags.get(id);
    }

    boolean updateFastForward(String refName, ObjectId oldValue, ObjectId newValue) {
        ObjectId cur;
        CachedRef ref = this.refs.get(refName);
        if (ref != null && (cur = (ObjectId)ref.get()).equals(oldValue)) {
            return ref.compareAndSet(cur, newValue);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(TagMatcher m) {
        try (RevWalk rw = null;){
            for (Ref currentRef : m.include) {
                if (currentRef.isSymbolic() || currentRef.getObjectId() == null) continue;
                CachedRef savedRef = this.refs.get(currentRef.getName());
                if (savedRef == null) {
                    m.newRefs.add(currentRef);
                    continue;
                }
                ObjectId savedObjectId = (ObjectId)savedRef.get();
                if (currentRef.getObjectId().equals(savedObjectId)) {
                    m.mask.set(savedRef.flag);
                    continue;
                }
                try {
                    RevCommit c;
                    RevCommit currentCommit;
                    RevCommit savedCommit;
                    if (rw == null) {
                        rw = new RevWalk(m.db);
                        rw.setRetainBody(false);
                    }
                    if (rw.isMergedInto(savedCommit = rw.parseCommit(savedObjectId), currentCommit = rw.parseCommit(currentRef.getObjectId()))) {
                        savedRef.compareAndSet(savedObjectId, currentRef.getObjectId());
                        m.mask.set(savedRef.flag);
                        continue;
                    }
                    boolean err = false;
                    rw.reset();
                    rw.markStart(savedCommit);
                    rw.markUninteresting(currentCommit);
                    rw.sort(RevSort.TOPO, true);
                    while ((c = rw.next()) != null) {
                        Tag tag = this.tags.get(c);
                        if (tag == null || !tag.refFlags.get(savedRef.flag)) continue;
                        m.lostRefs.add(new TagMatcher.LostRef(tag, savedRef.flag));
                        err = true;
                    }
                    if (err) continue;
                    savedRef.compareAndSet(savedObjectId, currentRef.getObjectId());
                    m.mask.set(savedRef.flag);
                }
                catch (IOException err) {
                    log.warn("Error checking tags of " + this.projectName, err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build(Repository git, TagSet old, TagMatcher m) {
        if (old != null && m != null && this.refresh(old, m)) {
            return;
        }
        rw.setRetainBody(false);
        try (TagWalk rw = new TagWalk(git);){
            TagCommit c;
            for (Ref ref : git.getRefDatabase().getRefs("").values()) {
                if (TagSet.skip(ref)) continue;
                if (TagSet.isTag(ref)) {
                    this.addTag(rw, git.peel(ref));
                    continue;
                }
                this.addRef(rw, ref);
            }
            while ((c = (TagCommit)rw.next()) != null) {
                BitSet mine = c.refFlags;
                int pCnt = c.getParentCount();
                for (int pIdx = 0; pIdx < pCnt; ++pIdx) {
                    ((TagCommit)c.getParent((int)pIdx)).refFlags.or(mine);
                }
            }
        }
    }

    void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int refCnt = in.readInt();
        for (int i = 0; i < refCnt; ++i) {
            String name = in.readUTF();
            int flag = in.readInt();
            ObjectId id = ObjectIdSerialization.readNotNull(in);
            this.refs.put(name, new CachedRef(flag, id));
        }
        int tagCnt = in.readInt();
        for (int i = 0; i < tagCnt; ++i) {
            ObjectId id = ObjectIdSerialization.readNotNull(in);
            BitSet flags = (BitSet)in.readObject();
            this.tags.add(new Tag(id, flags));
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.refs.size());
        for (Map.Entry<String, CachedRef> e : this.refs.entrySet()) {
            out.writeUTF(e.getKey());
            out.writeInt(e.getValue().flag);
            ObjectIdSerialization.writeNotNull(out, (AnyObjectId)e.getValue().get());
        }
        out.writeInt(this.tags.size());
        for (Tag tag : this.tags) {
            ObjectIdSerialization.writeNotNull(out, tag);
            out.writeObject(tag.refFlags);
        }
    }

    private boolean refresh(TagSet old, TagMatcher m) {
        ObjectId id;
        if (m.newRefs.isEmpty()) {
            this.copy(old, m);
            return true;
        }
        HashMap<ObjectId, Integer> byObj = new HashMap<ObjectId, Integer>();
        for (CachedRef r : old.refs.values()) {
            id = (ObjectId)r.get();
            if (byObj.containsKey(id)) continue;
            byObj.put(id, r.flag);
        }
        for (Ref newRef : m.newRefs) {
            id = newRef.getObjectId();
            if (id == null || this.refs.containsKey(newRef.getName()) || byObj.containsKey(id)) continue;
            return false;
        }
        this.copy(old, m);
        for (Ref newRef : m.newRefs) {
            id = newRef.getObjectId();
            if (id == null || this.refs.containsKey(newRef.getName())) continue;
            int srcFlag = (Integer)byObj.get(id);
            int newFlag = this.refs.size();
            this.refs.put(newRef.getName(), new CachedRef(newRef, newFlag));
            for (Tag tag : this.tags) {
                if (!tag.refFlags.get(srcFlag)) continue;
                tag.refFlags.set(newFlag);
            }
        }
        return true;
    }

    private void copy(TagSet old, TagMatcher m) {
        Serializable mine;
        this.refs.putAll(old.refs);
        for (Tag srcTag : old.tags) {
            mine = new BitSet();
            mine.or(srcTag.refFlags);
            this.tags.add(new Tag(srcTag, (BitSet)mine));
        }
        for (TagMatcher.LostRef lost : m.lostRefs) {
            mine = this.tags.get(lost.tag);
            if (mine == null) continue;
            ((Tag)mine).refFlags.clear(lost.flag);
        }
    }

    private void addTag(TagWalk rw, Ref ref) {
        ObjectId id = ref.getPeeledObjectId();
        if (id == null) {
            id = ref.getObjectId();
        }
        if (!this.tags.contains(id)) {
            BitSet flags;
            try {
                flags = ((TagCommit)rw.parseCommit((AnyObjectId)id)).refFlags;
            }
            catch (IncorrectObjectTypeException notCommit) {
                flags = new BitSet();
            }
            catch (IOException e) {
                log.warn("Error on " + ref.getName() + " of " + this.projectName, e);
                flags = new BitSet();
            }
            this.tags.add(new Tag(id, flags));
        }
    }

    private void addRef(TagWalk rw, Ref ref) {
        try {
            TagCommit commit = (TagCommit)rw.parseCommit(ref.getObjectId());
            rw.markStart(commit);
            int flag = this.refs.size();
            commit.refFlags.set(flag);
            this.refs.put(ref.getName(), new CachedRef(ref, flag));
        }
        catch (IncorrectObjectTypeException notCommit) {
        }
        catch (IOException e) {
            log.warn("Error on " + ref.getName() + " of " + this.projectName, e);
        }
    }

    private static boolean skip(Ref ref) {
        return ref.isSymbolic() || ref.getObjectId() == null || PatchSet.isRef(ref.getName());
    }

    private static boolean isTag(Ref ref) {
        return ref.getName().startsWith("refs/tags/");
    }

    private static final class TagCommit
    extends RevCommit {
        final BitSet refFlags = new BitSet();

        TagCommit(AnyObjectId id) {
            super(id);
        }
    }

    private static final class TagWalk
    extends RevWalk {
        TagWalk(Repository git) {
            super(git);
        }

        @Override
        protected TagCommit createCommit(AnyObjectId id) {
            return new TagCommit(id);
        }
    }

    private static final class CachedRef
    extends AtomicReference<ObjectId> {
        private static final long serialVersionUID = 1L;
        final int flag;

        CachedRef(Ref ref, int flag) {
            this(flag, ref.getObjectId());
        }

        CachedRef(int flag, ObjectId id) {
            this.flag = flag;
            this.set(id);
        }
    }

    static final class Tag
    extends ObjectIdOwnerMap.Entry {
        private final BitSet refFlags;

        Tag(AnyObjectId id, BitSet flags) {
            super(id);
            this.refFlags = flags;
        }

        boolean has(BitSet mask) {
            return this.refFlags.intersects(mask);
        }
    }
}

