/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.changedetail.RebaseChange;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.strategy.CherryPick;
import com.google.gerrit.server.git.strategy.FastForwardOnly;
import com.google.gerrit.server.git.strategy.MergeAlways;
import com.google.gerrit.server.git.strategy.MergeIfNecessary;
import com.google.gerrit.server.git.strategy.RebaseIfNecessary;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SubmitStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SubmitStrategyFactory.class);
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final Provider<PersonIdent> myIdent;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final RebaseChange rebaseChange;
    private final ProjectCache projectCache;
    private final ApprovalsUtil approvalsUtil;
    private final MergeUtil.Factory mergeUtilFactory;
    private final ChangeIndexer indexer;

    @Inject
    SubmitStrategyFactory(IdentifiedUser.GenericFactory identifiedUserFactory, @GerritPersonIdent Provider<PersonIdent> myIdent, ChangeControl.GenericFactory changeControlFactory, PatchSetInfoFactory patchSetInfoFactory, GitReferenceUpdated gitRefUpdated, RebaseChange rebaseChange, ProjectCache projectCache, ApprovalsUtil approvalsUtil, MergeUtil.Factory mergeUtilFactory, ChangeIndexer indexer) {
        this.identifiedUserFactory = identifiedUserFactory;
        this.myIdent = myIdent;
        this.changeControlFactory = changeControlFactory;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.rebaseChange = rebaseChange;
        this.projectCache = projectCache;
        this.approvalsUtil = approvalsUtil;
        this.mergeUtilFactory = mergeUtilFactory;
        this.indexer = indexer;
    }

    public SubmitStrategy create(SubmitType submitType, ReviewDb db, Repository repo, RevWalk rw, ObjectInserter inserter, RevFlag canMergeFlag, Set<RevCommit> alreadyAccepted, Branch.NameKey destBranch) throws MergeException, NoSuchProjectException {
        ProjectState project = this.getProject(destBranch);
        SubmitStrategy.Arguments args = new SubmitStrategy.Arguments(this.identifiedUserFactory, this.myIdent, db, this.changeControlFactory, repo, rw, inserter, canMergeFlag, alreadyAccepted, destBranch, this.approvalsUtil, this.mergeUtilFactory.create(project), this.indexer);
        switch (submitType) {
            case CHERRY_PICK: {
                return new CherryPick(args, this.patchSetInfoFactory, this.gitRefUpdated);
            }
            case FAST_FORWARD_ONLY: {
                return new FastForwardOnly(args);
            }
            case MERGE_ALWAYS: {
                return new MergeAlways(args);
            }
            case MERGE_IF_NECESSARY: {
                return new MergeIfNecessary(args);
            }
            case REBASE_IF_NECESSARY: {
                return new RebaseIfNecessary(args, this.patchSetInfoFactory, this.rebaseChange);
            }
        }
        String errorMsg = "No submit strategy for: " + (Object)((Object)submitType);
        log.error(errorMsg);
        throw new MergeException(errorMsg);
    }

    private ProjectState getProject(Branch.NameKey branch) throws NoSuchProjectException {
        ProjectState p = this.projectCache.get(branch.getParentKey());
        if (p == null) {
            throw new NoSuchProjectException(branch.getParentKey());
        }
        return p;
    }
}

