/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.project.BanCommit;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="ban-commit", description="Ban a commit from a project's repository", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class BanCommitCommand
extends SshCommand {
    @Option(name="--reason", aliases={"-r"}, metaVar="REASON", usage="reason for banning the commit")
    private String reason;
    @Argument(index=0, required=true, metaVar="PROJECT", usage="name of the project for which the commit should be banned")
    private ProjectControl projectControl;
    @Argument(index=1, required=true, multiValued=true, metaVar="COMMIT", usage="commit(s) that should be banned")
    private List<ObjectId> commitsToBan = new ArrayList<ObjectId>();
    @Inject
    private BanCommit banCommit;

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            BanCommit.Input input = BanCommit.Input.fromCommits(Lists.transform(this.commitsToBan, new Function<ObjectId, String>(){

                @Override
                public String apply(ObjectId oid) {
                    return oid.getName();
                }
            }));
            input.reason = this.reason;
            BanCommit.BanResultInfo r = this.banCommit.apply(new ProjectResource(this.projectControl), input);
            this.printCommits(r.newlyBanned, "The following commits were banned");
            this.printCommits(r.alreadyBanned, "The following commits were already banned");
            this.printCommits(r.ignored, "The following ids do not represent commits and were ignored");
        }
        catch (RestApiException | IOException | InterruptedException e) {
            throw this.die(e);
        }
    }

    private void printCommits(List<String> commits, String message) {
        if (CollectionUtils.isNotEmpty(commits)) {
            this.stdout.print(message + ":\n");
            this.stdout.print(Joiner.on(",\n").join(commits));
            this.stdout.print("\n\n");
        }
    }
}

