/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.util.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCommand
implements Command,
Runnable,
FileSystemAware {
    protected static final Logger log = LoggerFactory.getLogger(ScpCommand.class);
    protected String name;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected FileSystemView root;
    protected String path;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;
    protected ExecutorService executors;
    protected boolean shutdownExecutor;
    protected Future<?> pendingFuture;
    protected int sendBufferSize;
    protected int receiveBufferSize;

    public ScpCommand(String command) {
        this(command, 8192);
    }

    public ScpCommand(String command, int bufferSize) {
        this(command, null, bufferSize);
    }

    public ScpCommand(String command, ExecutorService executorService, int bufferSize) {
        this(command, executorService, false, bufferSize);
    }

    public ScpCommand(String command, ExecutorService executorService) {
        this(command, executorService, false);
    }

    public ScpCommand(String command, ExecutorService executorService, boolean shutdownOnExit) {
        this(command, executorService, false, 8192);
    }

    public ScpCommand(String command, ExecutorService executorService, boolean shutdownOnExit, int bufferSize) {
        this(command, executorService, shutdownOnExit, bufferSize, bufferSize);
    }

    public ScpCommand(String command, ExecutorService executorService, boolean shutdownOnExit, int sendSize, int receiveSize) {
        this.name = command;
        this.executors = executorService;
        if (this.executors == null) {
            String poolName = command.replace(' ', '_').replace('/', ':');
            this.executors = ThreadUtils.newSingleThreadExecutor(poolName);
            this.shutdownExecutor = true;
        } else {
            this.shutdownExecutor = shutdownOnExit;
        }
        this.sendBufferSize = sendSize;
        if (this.sendBufferSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        if (this.receiveBufferSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        log.debug("Executing command {}", (Object)command);
        String[] args = command.split(" ");
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block8: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                        }
                    }
                }
                continue;
            }
            this.path = command.substring(command.indexOf(args[i - 1]) + args[i - 1].length() + 1);
            if ((!this.path.startsWith("\"") || !this.path.endsWith("\"")) && (!this.path.startsWith("'") || !this.path.endsWith("'"))) break;
            this.path = this.path.substring(1, this.path.length() - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }

    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        try {
            this.pendingFuture = this.executors.submit(this);
        }
        catch (RuntimeException e) {
            log.error("Failed (" + e.getClass().getSimpleName() + ") to start command=" + this.name + ": " + e.getMessage(), e);
            throw new IOException(e);
        }
    }

    public void destroy() {
        if (this.pendingFuture != null && !this.pendingFuture.isDone()) {
            boolean result = this.pendingFuture.cancel(true);
            if (log.isDebugEnabled()) {
                log.debug("destroy() - cancel pending future=" + result);
            }
        }
        this.pendingFuture = null;
        if (this.executors != null && this.shutdownExecutor) {
            List<Runnable> runners = this.executors.shutdownNow();
            if (log.isDebugEnabled()) {
                log.debug("destroy() - shutdown executor service - runners count=" + (runners == null ? 0 : runners.size()));
            }
        }
        this.executors = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        ScpHelper helper = new ScpHelper(this.in, this.out, this.root);
        try {
            if (this.optT) {
                helper.receive(this.root.getFile(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
            } else if (this.optF) {
                helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
            } else {
                throw new IOException("Unsupported mode");
            }
            if (this.callback != null) {
                this.callback.onExit(exitValue, exitMessage);
            }
        }
        catch (IOException e) {
            try {
                try {
                    exitValue = 2;
                    exitMessage = e.getMessage() == null ? "" : e.getMessage();
                    this.out.write(exitValue);
                    this.out.write(exitMessage.getBytes());
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                log.info("Error in scp command=" + this.name, e);
                if (this.callback != null) {
                    this.callback.onExit(exitValue, exitMessage);
                }
            }
            catch (Throwable throwable) {
                if (this.callback != null) {
                    this.callback.onExit(exitValue, exitMessage);
                }
                throw throwable;
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

