/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;

public final class TgzFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".tar.gz", ".tgz"));
    private final ArchiveCommand.Format<ArchiveOutputStream> tarFormat = new TarFormat();

    @Override
    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    @Override
    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        GzipCompressorOutputStream out = new GzipCompressorOutputStream(s);
        return this.tarFormat.createArchiveOutputStream(out, o);
    }

    @Override
    public void putEntry(ArchiveOutputStream out, String path, FileMode mode, ObjectLoader loader) throws IOException {
        this.tarFormat.putEntry(out, path, mode, loader);
    }

    @Override
    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof TgzFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

