/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gwtorm.client.KeyUtil;

public class PageLinks {
    public static final String SETTINGS = "/settings/";
    public static final String SETTINGS_PREFERENCES = "/settings/preferences";
    public static final String SETTINGS_SSHKEYS = "/settings/ssh-keys";
    public static final String SETTINGS_HTTP_PASSWORD = "/settings/http-password";
    public static final String SETTINGS_WEBIDENT = "/settings/web-identities";
    public static final String SETTINGS_MYGROUPS = "/settings/group-memberships";
    public static final String SETTINGS_AGREEMENTS = "/settings/agreements";
    public static final String SETTINGS_CONTACT = "/settings/contact";
    public static final String SETTINGS_PROJECTS = "/settings/projects";
    public static final String SETTINGS_NEW_AGREEMENT = "/settings/new-agreement";
    public static final String REGISTER = "/register";
    public static final String MINE = "/";
    public static final String QUERY = "/q/";
    public static final String PROJECTS = "/projects/";
    public static final String DASHBOARDS = ",dashboards/";
    public static final String ADMIN_GROUPS = "/admin/groups/";
    public static final String ADMIN_CREATE_GROUP = "/admin/create-group/";
    public static final String ADMIN_PROJECTS = "/admin/projects/";
    public static final String ADMIN_CREATE_PROJECT = "/admin/create-project/";
    public static final String ADMIN_PLUGINS = "/admin/plugins/";
    public static final String MY_GROUPS = "/groups/self";

    public static String toChange(ChangeInfo c) {
        return PageLinks.toChange(c.getId());
    }

    public static String toChange(Change.Id c) {
        return "/c/" + c + MINE;
    }

    public static String toChange(Change.Id c, String p) {
        return "/c/" + c + MINE + p;
    }

    public static String toChange(Change.Id c, String b, String p) {
        String u = "/c/" + c + MINE;
        if (b != null) {
            u = u + b + "..";
        }
        u = u + p;
        return u;
    }

    public static String toChange(PatchSet.Id ps) {
        return "/c/" + ps.getParentKey() + MINE + ps.get();
    }

    public static String toProject(Project.NameKey p) {
        return ADMIN_PROJECTS + p.get();
    }

    public static String toProjectAcceess(Project.NameKey p) {
        return ADMIN_PROJECTS + p.get() + ",access";
    }

    public static String toProjectBranches(Project.NameKey p) {
        return ADMIN_PROJECTS + p.get() + ",branches";
    }

    public static String toAccountQuery(String fullname, Change.Status status) {
        return PageLinks.toChangeQuery(PageLinks.op("owner", fullname) + " " + PageLinks.status(status));
    }

    public static String toCustomDashboard(String params) {
        return "/dashboard/?" + params;
    }

    public static String toProjectDashboards(Project.NameKey proj) {
        return ADMIN_PROJECTS + proj.get() + ",dashboards";
    }

    public static String toChangeQuery(String query) {
        return QUERY + KeyUtil.encode(query);
    }

    public static String toChangeQuery(String query, String start) {
        int s = Integer.parseInt(start);
        return QUERY + KeyUtil.encode(query) + (s > 0 ? "," + s : "");
    }

    public static String toProjectDashboard(Project.NameKey name, String id) {
        return PROJECTS + name.get() + DASHBOARDS + id;
    }

    public static String toProjectDefaultDashboard(Project.NameKey name) {
        return PROJECTS + name.get() + DASHBOARDS + "default";
    }

    public static String projectQuery(Project.NameKey proj) {
        return PageLinks.op("project", proj.get());
    }

    public static String projectQuery(Project.NameKey proj, Change.Status status) {
        return PageLinks.status(status) + " " + PageLinks.op("project", proj.get());
    }

    public static String toGroup(AccountGroup.UUID uuid) {
        return "/admin/groups/uuid-" + uuid;
    }

    private static String status(Change.Status status) {
        switch (status) {
            case ABANDONED: {
                return "status:abandoned";
            }
            case MERGED: {
                return "status:merged";
            }
        }
        return "status:open";
    }

    public static String op(String op, int value) {
        return op + ":" + value;
    }

    public static String op(String op, String value) {
        if (PageLinks.isSingleWord(value)) {
            return op + ":" + value;
        }
        return op + ":\"" + value + "\"";
    }

    private static boolean isSingleWord(String value) {
        if (value.startsWith("-")) {
            return false;
        }
        return value.matches("[^\u0000- !\"#$%&'():;?\\[\\]{}~]+");
    }

    protected PageLinks() {
    }
}

