/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.GitwebConfig;
import com.google.gerrit.httpd.GitWebConfig;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.GetArchive;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.DownloadConfig;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.contact.ContactStore;
import com.google.gerrit.server.mail.EmailSender;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.eclipse.jgit.lib.Config;

class GerritConfigProvider
implements Provider<GerritConfig> {
    private final Realm realm;
    private final Config cfg;
    private final AuthConfig authConfig;
    private final DownloadConfig downloadConfig;
    private final GetArchive.AllowedFormats archiveFormats;
    private final GitWebConfig gitWebConfig;
    private final AllProjectsName wildProject;
    private final SshInfo sshInfo;
    private EmailSender emailSender;
    private final ContactStore contactStore;
    private final ServletContext servletContext;
    private final String anonymousCowardName;

    @Inject
    GerritConfigProvider(Realm r, @GerritServerConfig Config gsc, AuthConfig ac, GitWebConfig gwc, AllProjectsName wp, SshInfo si, ContactStore cs, ServletContext sc, DownloadConfig dc, GetArchive.AllowedFormats af, @AnonymousCowardName String acn) {
        this.realm = r;
        this.cfg = gsc;
        this.authConfig = ac;
        this.downloadConfig = dc;
        this.archiveFormats = af;
        this.gitWebConfig = gwc;
        this.sshInfo = si;
        this.wildProject = wp;
        this.contactStore = cs;
        this.servletContext = sc;
        this.anonymousCowardName = acn;
    }

    @Inject(optional=true)
    void setEmailSender(EmailSender d) {
        this.emailSender = d;
    }

    private GerritConfig create() throws MalformedURLException {
        GerritConfig config = new GerritConfig();
        switch (this.authConfig.getAuthType()) {
            case LDAP: 
            case LDAP_BIND: {
                config.setRegisterUrl(this.cfg.getString("auth", null, "registerurl"));
                config.setRegisterText(this.cfg.getString("auth", null, "registertext"));
                config.setEditFullNameUrl(this.cfg.getString("auth", null, "editFullNameUrl"));
                config.setHttpPasswordSettingsEnabled(!this.authConfig.isGitBasicAuth());
                break;
            }
            case CUSTOM_EXTENSION: {
                config.setRegisterUrl(this.cfg.getString("auth", null, "registerurl"));
                config.setRegisterText(this.cfg.getString("auth", null, "registertext"));
                config.setEditFullNameUrl(this.cfg.getString("auth", null, "editFullNameUrl"));
                config.setHttpPasswordUrl(this.cfg.getString("auth", null, "httpPasswordUrl"));
                break;
            }
            case HTTP: 
            case HTTP_LDAP: {
                config.setLoginUrl(this.cfg.getString("auth", null, "loginurl"));
                config.setLoginText(this.cfg.getString("auth", null, "logintext"));
                break;
            }
        }
        config.setSwitchAccountUrl(this.cfg.getString("auth", null, "switchAccountUrl"));
        config.setUseContributorAgreements(this.cfg.getBoolean("auth", "contributoragreements", false));
        config.setGitDaemonUrl(this.cfg.getString("gerrit", null, "canonicalgiturl"));
        config.setGitHttpUrl(this.cfg.getString("gerrit", null, "gitHttpUrl"));
        config.setUseContactInfo(this.contactStore != null && this.contactStore.isEnabled());
        config.setDownloadSchemes(this.downloadConfig.getDownloadSchemes());
        config.setDownloadCommands(this.downloadConfig.getDownloadCommands());
        config.setAuthType(this.authConfig.getAuthType());
        config.setWildProject(this.wildProject);
        config.setDocumentationAvailable(this.servletContext.getResource("/Documentation/index.html") != null);
        config.setAnonymousCowardName(this.anonymousCowardName);
        config.setSuggestFrom(this.cfg.getInt("suggest", "from", 0));
        config.setChangeUpdateDelay((int)ConfigUtil.getTimeUnit(this.cfg, "change", null, "updateDelay", 30L, TimeUnit.SECONDS));
        config.setChangeScreen(this.cfg.getEnum("gerrit", null, "changeScreen", AccountGeneralPreferences.ChangeScreen.CHANGE_SCREEN2));
        config.setLargeChangeSize(this.cfg.getInt("change", "largeChange", 500));
        config.setArchiveFormats(Lists.newArrayList(Iterables.transform(this.archiveFormats.getAllowed(), new Function<ArchiveFormat, String>(){

            @Override
            public String apply(ArchiveFormat in) {
                return in.getShortName();
            }
        })));
        config.setNewFeatures(this.cfg.getBoolean("gerrit", "enableNewFeatures", true));
        String reportBugUrl = this.cfg.getString("gerrit", null, "reportBugUrl");
        config.setReportBugUrl(reportBugUrl != null ? reportBugUrl : "http://code.google.com/p/gerrit/issues/list");
        config.setReportBugText(this.cfg.getString("gerrit", null, "reportBugText"));
        HashSet<Account.FieldName> fields = new HashSet<Account.FieldName>();
        for (Account.FieldName n : Account.FieldName.values()) {
            if (!this.realm.allowsEdit(n)) continue;
            fields.add(n);
        }
        if (this.emailSender != null && this.emailSender.isEnabled() && this.realm.allowsEdit(Account.FieldName.REGISTER_NEW_EMAIL)) {
            fields.add(Account.FieldName.REGISTER_NEW_EMAIL);
        }
        config.setEditableAccountFields(fields);
        if (this.gitWebConfig.getUrl() != null) {
            config.setGitwebLink(new GitwebConfig(this.gitWebConfig.getUrl(), this.gitWebConfig.getGitWebType()));
        }
        if (this.sshInfo != null && !this.sshInfo.getHostKeys().isEmpty()) {
            config.setSshdAddress(this.sshInfo.getHostKeys().get(0).getHost());
        }
        return config;
    }

    @Override
    public GerritConfig get() {
        try {
            return this.create();
        }
        catch (MalformedURLException e) {
            throw new ProvisionException("Cannot create GerritConfig instance", e);
        }
    }
}

