/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Sets;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.validator.routines.EmailValidator;

@RequiresCapability(value="createAccount")
public class CreateAccount
implements RestModifyView<TopLevelResource, Input> {
    private final ReviewDb db;
    private final Provider<IdentifiedUser> currentUser;
    private final GroupsCollection groupsCollection;
    private final SshKeyCache sshKeyCache;
    private final AccountCache accountCache;
    private final AccountByEmailCache byEmailCache;
    private final AccountInfo.Loader.Factory infoLoader;
    private final String username;

    @Inject
    CreateAccount(ReviewDb db, Provider<IdentifiedUser> currentUser, GroupsCollection groupsCollection, SshKeyCache sshKeyCache, AccountCache accountCache, AccountByEmailCache byEmailCache, AccountInfo.Loader.Factory infoLoader, @Assisted String username) {
        this.db = db;
        this.currentUser = currentUser;
        this.groupsCollection = groupsCollection;
        this.sshKeyCache = sshKeyCache;
        this.accountCache = accountCache;
        this.byEmailCache = byEmailCache;
        this.infoLoader = infoLoader;
        this.username = username;
    }

    public Response<AccountInfo> apply(TopLevelResource rsrc, Input input) throws BadRequestException, ResourceConflictException, UnprocessableEntityException, OrmException {
        if (input == null) {
            input = new Input();
        }
        if (input.username != null && !this.username.equals(input.username)) {
            throw new BadRequestException("username must match URL");
        }
        if (!this.username.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$")) {
            throw new BadRequestException("Username '" + this.username + "'" + " must contain only letters, numbers, _, - or .");
        }
        Set<AccountGroup.Id> groups = this.parseGroups(input.groups);
        Account.Id id = new Account.Id(this.db.nextAccountId());
        AccountSshKey key = this.createSshKey(id, input.sshKey);
        AccountExternalId extUser = new AccountExternalId(id, new AccountExternalId.Key("username:", this.username));
        if (input.httpPassword != null) {
            extUser.setPassword(input.httpPassword);
        }
        if (this.db.accountExternalIds().get(extUser.getKey()) != null) {
            throw new ResourceConflictException("username '" + this.username + "' already exists");
        }
        if (input.email != null) {
            if (this.db.accountExternalIds().get(this.getEmailKey(input.email)) != null) {
                throw new UnprocessableEntityException("email '" + input.email + "' already exists");
            }
            if (!EmailValidator.getInstance().isValid(input.email)) {
                throw new BadRequestException("invalid email address");
            }
        }
        try {
            this.db.accountExternalIds().insert(Collections.singleton(extUser));
        }
        catch (OrmDuplicateKeyException duplicateKey) {
            throw new ResourceConflictException("username '" + this.username + "' already exists");
        }
        if (input.email != null) {
            AccountExternalId extMailto = new AccountExternalId(id, this.getEmailKey(input.email));
            extMailto.setEmailAddress(input.email);
            try {
                this.db.accountExternalIds().insert(Collections.singleton(extMailto));
            }
            catch (OrmDuplicateKeyException duplicateKey) {
                try {
                    this.db.accountExternalIds().delete(Collections.singleton(extUser));
                }
                catch (OrmException ormException) {
                    // empty catch block
                }
                throw new UnprocessableEntityException("email '" + input.email + "' already exists");
            }
        }
        Account a = new Account(id, TimeUtil.nowTs());
        a.setFullName(input.name);
        a.setPreferredEmail(input.email);
        this.db.accounts().insert(Collections.singleton(a));
        if (key != null) {
            this.db.accountSshKeys().insert(Collections.singleton(key));
        }
        for (AccountGroup.Id groupId : groups) {
            AccountGroupMember m = new AccountGroupMember(new AccountGroupMember.Key(id, groupId));
            this.db.accountGroupMembersAudit().insert(Collections.singleton(new AccountGroupMemberAudit(m, this.currentUser.get().getAccountId(), TimeUtil.nowTs())));
            this.db.accountGroupMembers().insert(Collections.singleton(m));
        }
        this.sshKeyCache.evict(this.username);
        this.accountCache.evictByUsername(this.username);
        this.byEmailCache.evict(input.email);
        AccountInfo.Loader loader = this.infoLoader.create(true);
        AccountInfo info = loader.get(id);
        loader.fill();
        return Response.created(info);
    }

    private Set<AccountGroup.Id> parseGroups(List<String> groups) throws UnprocessableEntityException {
        HashSet<AccountGroup.Id> groupIds = Sets.newHashSet();
        if (groups != null) {
            for (String g : groups) {
                groupIds.add(GroupDescriptions.toAccountGroup(this.groupsCollection.parseInternal(g)).getId());
            }
        }
        return groupIds;
    }

    private AccountSshKey createSshKey(Account.Id id, String sshKey) throws BadRequestException {
        if (sshKey == null) {
            return null;
        }
        try {
            return this.sshKeyCache.create(new AccountSshKey.Id(id, 1), sshKey.trim());
        }
        catch (InvalidSshKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private AccountExternalId.Key getEmailKey(String email) {
        return new AccountExternalId.Key("mailto:", email);
    }

    public static interface Factory {
        public CreateAccount create(String var1);
    }

    public static class Input {
        @DefaultInput
        public String username;
        public String name;
        public String email;
        public String sshKey;
        public String httpPassword;
        public List<String> groups;
    }
}

