/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.webui.TopMenu;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GetPreferences
implements RestReadView<AccountResource> {
    private static final Logger log = LoggerFactory.getLogger(GetPreferences.class);
    public static final String MY = "my";
    public static final String KEY_URL = "url";
    public static final String KEY_TARGET = "target";
    public static final String KEY_ID = "id";
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> db;
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitMgr;

    @Inject
    GetPreferences(Provider<CurrentUser> self, Provider<ReviewDb> db, AllUsersName allUsersName, GitRepositoryManager gitMgr) {
        this.self = self;
        this.db = db;
        this.allUsersName = allUsersName;
        this.gitMgr = gitMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreferenceInfo apply(AccountResource rsrc) throws AuthException, ResourceNotFoundException, OrmException, IOException, ConfigInvalidException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        Account a = this.db.get().accounts().get(rsrc.getUser().getAccountId());
        if (a == null) {
            throw new ResourceNotFoundException();
        }
        try (Repository git = this.gitMgr.openRepository(this.allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forUser(rsrc.getUser().getAccountId());
            p.load(git);
            PreferenceInfo preferenceInfo = new PreferenceInfo(a.getGeneralPreferences(), p, git);
            return preferenceInfo;
        }
    }

    public static class PreferenceInfo {
        Short changesPerPage;
        Boolean showSiteHeader;
        Boolean useFlashClipboard;
        AccountGeneralPreferences.DownloadScheme downloadScheme;
        AccountGeneralPreferences.DownloadCommand downloadCommand;
        Boolean copySelfOnEmail;
        AccountGeneralPreferences.DateFormat dateFormat;
        AccountGeneralPreferences.TimeFormat timeFormat;
        Boolean reversePatchSetOrder;
        Boolean relativeDateInChangeTable;
        Boolean sizeBarInChangeTable;
        Boolean legacycidInChangeTable;
        AccountGeneralPreferences.ReviewCategoryStrategy reviewCategoryStrategy;
        AccountGeneralPreferences.CommentVisibilityStrategy commentVisibilityStrategy;
        AccountGeneralPreferences.DiffView diffView;
        AccountGeneralPreferences.ChangeScreen changeScreen;
        List<TopMenu.MenuItem> my;

        public PreferenceInfo(AccountGeneralPreferences p, VersionedAccountPreferences v, Repository allUsers) {
            if (p != null) {
                this.changesPerPage = p.getMaximumPageSize();
                this.showSiteHeader = p.isShowSiteHeader() ? Boolean.valueOf(true) : null;
                this.useFlashClipboard = p.isUseFlashClipboard() ? Boolean.valueOf(true) : null;
                this.downloadScheme = p.getDownloadUrl();
                this.downloadCommand = p.getDownloadCommand();
                this.copySelfOnEmail = p.isCopySelfOnEmails() ? Boolean.valueOf(true) : null;
                this.dateFormat = p.getDateFormat();
                this.timeFormat = p.getTimeFormat();
                this.reversePatchSetOrder = p.isReversePatchSetOrder() ? Boolean.valueOf(true) : null;
                this.relativeDateInChangeTable = p.isRelativeDateInChangeTable() ? Boolean.valueOf(true) : null;
                this.sizeBarInChangeTable = p.isSizeBarInChangeTable() ? Boolean.valueOf(true) : null;
                this.legacycidInChangeTable = p.isLegacycidInChangeTable() ? Boolean.valueOf(true) : null;
                this.reviewCategoryStrategy = p.getReviewCategoryStrategy();
                this.commentVisibilityStrategy = p.getCommentVisibilityStrategy();
                this.diffView = p.getDiffView();
                this.changeScreen = p.getChangeScreen();
            }
            this.my = this.my(v, allUsers);
        }

        private List<TopMenu.MenuItem> my(VersionedAccountPreferences v, Repository allUsers) {
            List<TopMenu.MenuItem> my = this.my(v);
            if (my.isEmpty() && !v.isDefaults()) {
                try {
                    VersionedAccountPreferences d = VersionedAccountPreferences.forDefault();
                    d.load(allUsers);
                    my = this.my(d);
                }
                catch (IOException | ConfigInvalidException e) {
                    log.warn("cannot read default preferences", e);
                }
            }
            if (my.isEmpty()) {
                my.add(new TopMenu.MenuItem("Changes", "#/dashboard/self", null));
                my.add(new TopMenu.MenuItem("Drafts", "#/q/is:draft", null));
                my.add(new TopMenu.MenuItem("Draft Comments", "#/q/has:draft", null));
                my.add(new TopMenu.MenuItem("Watched Changes", "#/q/is:watched+is:open", null));
                my.add(new TopMenu.MenuItem("Starred Changes", "#/q/is:starred", null));
                my.add(new TopMenu.MenuItem("Groups", "#/groups/self", null));
            }
            return my;
        }

        private List<TopMenu.MenuItem> my(VersionedAccountPreferences v) {
            ArrayList<TopMenu.MenuItem> my = new ArrayList<TopMenu.MenuItem>();
            Config cfg = v.getConfig();
            Iterator<String> i$ = cfg.getSubsections(GetPreferences.MY).iterator();
            while (i$.hasNext()) {
                String subsection;
                String url = PreferenceInfo.my(cfg, subsection = i$.next(), GetPreferences.KEY_URL, "#/");
                String target = PreferenceInfo.my(cfg, subsection, GetPreferences.KEY_TARGET, url.startsWith("#") ? null : "_blank");
                my.add(new TopMenu.MenuItem(subsection, url, target, PreferenceInfo.my(cfg, subsection, GetPreferences.KEY_ID, null)));
            }
            return my;
        }

        private static String my(Config cfg, String subsection, String key, String defaultValue) {
            String val = cfg.getString(GetPreferences.MY, subsection, key);
            return !Strings.isNullOrEmpty(val) ? val : defaultValue;
        }
    }
}

