/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.auth.ldap.Helper;
import com.google.gerrit.server.auth.ldap.LdapGroupBackend;
import com.google.gerrit.server.auth.ldap.LdapRealm;
import com.google.gerrit.server.cache.CacheModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class LdapModule
extends CacheModule {
    static final String USERNAME_CACHE = "ldap_usernames";
    static final String GROUP_CACHE = "ldap_groups";
    static final String GROUP_EXIST_CACHE = "ldap_group_existence";
    static final String PARENT_GROUPS_CACHE = "ldap_groups_byinclude";

    @Override
    protected void configure() {
        this.cache(GROUP_CACHE, String.class, new TypeLiteral<Set<AccountGroup.UUID>>(){}).expireAfterWrite(1L, TimeUnit.HOURS).loader(LdapRealm.MemberLoader.class);
        this.cache(USERNAME_CACHE, String.class, new TypeLiteral<Optional<Account.Id>>(){}).loader(LdapRealm.UserLoader.class);
        this.cache(GROUP_EXIST_CACHE, String.class, new TypeLiteral<Boolean>(){}).expireAfterWrite(1L, TimeUnit.HOURS).loader(LdapRealm.ExistenceLoader.class);
        this.cache(PARENT_GROUPS_CACHE, String.class, new TypeLiteral<ImmutableSet<String>>(){}).expireAfterWrite(1L, TimeUnit.HOURS);
        this.bind(Helper.class);
        this.bind(Realm.class).to(LdapRealm.class).in(Scopes.SINGLETON);
        DynamicSet.bind(this.binder(), GroupBackend.class).to(LdapGroupBackend.class);
    }
}

