/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth.ldap;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

abstract class LdapType {
    static final LdapType RFC_2307 = new Rfc2307();

    LdapType() {
    }

    static LdapType guessType(DirContext ctx) throws NamingException {
        Attributes rootAtts = ctx.getAttributes("");
        Attribute supported = rootAtts.get("supportedCapabilities");
        if (supported != null && (supported.contains("1.2.840.113556.1.4.800") || supported.contains("1.2.840.113556.1.4.1851"))) {
            return new ActiveDirectory();
        }
        return RFC_2307;
    }

    abstract String groupPattern();

    abstract String groupMemberPattern();

    abstract String groupName();

    abstract String accountFullName();

    abstract String accountEmailAddress();

    abstract String accountSshUserName();

    abstract String accountMemberField();

    abstract String accountPattern();

    private static class ActiveDirectory
    extends LdapType {
        private ActiveDirectory() {
        }

        @Override
        String groupPattern() {
            return "(&(objectClass=group)(cn=${groupname}))";
        }

        @Override
        String groupName() {
            return "cn";
        }

        @Override
        String groupMemberPattern() {
            return null;
        }

        @Override
        String accountFullName() {
            return "${givenName} ${sn}";
        }

        @Override
        String accountEmailAddress() {
            return "mail";
        }

        @Override
        String accountSshUserName() {
            return "${sAMAccountName.toLowerCase}";
        }

        @Override
        String accountMemberField() {
            return "memberOf";
        }

        @Override
        String accountPattern() {
            return "(&(objectClass=user)(sAMAccountName=${username}))";
        }
    }

    private static class Rfc2307
    extends LdapType {
        private Rfc2307() {
        }

        @Override
        String groupPattern() {
            return "(cn=${groupname})";
        }

        @Override
        String groupMemberPattern() {
            return "(|(memberUid=${username})(gidNumber=${gidNumber}))";
        }

        @Override
        String groupName() {
            return "cn";
        }

        @Override
        String accountFullName() {
            return "displayName";
        }

        @Override
        String accountEmailAddress() {
            return "mail";
        }

        @Override
        String accountSshUserName() {
            return "uid";
        }

        @Override
        String accountMemberField() {
            return null;
        }

        @Override
        String accountPattern() {
            return "(uid=${username})";
        }
    }
}

