/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Objects;
import com.google.gerrit.extensions.common.SubmitType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.TestSubmitRule;
import com.google.gerrit.server.project.RuleEvalException;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.kohsuke.args4j.Option;

public class TestSubmitType
implements RestModifyView<RevisionResource, TestSubmitRule.Input> {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final RulesCache rules;
    @Option(name="--filters", usage="impact of filters in parent projects")
    private TestSubmitRule.Filters filters = TestSubmitRule.Filters.RUN;

    @Inject
    TestSubmitType(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, RulesCache rules) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.rules = rules;
    }

    public SubmitType apply(RevisionResource rsrc, TestSubmitRule.Input input) throws AuthException, BadRequestException {
        List<Term> results;
        if (input == null) {
            input = new TestSubmitRule.Input();
        }
        if (input.rule != null && !this.rules.isProjectRulesEnabled()) {
            throw new AuthException("project rules are disabled");
        }
        input.filters = Objects.firstNonNull(input.filters, this.filters);
        SubmitRuleEvaluator evaluator = new SubmitRuleEvaluator(this.db.get(), rsrc.getPatchSet(), rsrc.getControl().getProjectControl(), rsrc.getControl(), rsrc.getChange(), this.changeDataFactory.create(this.db.get(), rsrc.getChange()), false, "locate_submit_type", "get_submit_type", "locate_submit_type_filter", "filter_submit_type_results", input.filters == TestSubmitRule.Filters.SKIP, input.rule != null ? new ByteArrayInputStream(input.rule.getBytes(StandardCharsets.UTF_8)) : null);
        try {
            results = evaluator.evaluate();
        }
        catch (RuleEvalException e) {
            throw new BadRequestException(String.format("rule failed with exception: %s", e.getMessage()));
        }
        if (results.isEmpty()) {
            throw new BadRequestException(String.format("rule %s has no solution", evaluator.getSubmitRule()));
        }
        Term type = results.get(0);
        if (!type.isSymbol()) {
            throw new BadRequestException(String.format("rule %s produced invalid result: %s", evaluator.getSubmitRule().toString(), type));
        }
        String typeName = ((SymbolTerm)type).name();
        try {
            return SubmitType.valueOf(typeName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(String.format("rule %s produced invalid result: %s", evaluator.getSubmitRule().toString(), type));
        }
    }

    static class Get
    implements RestReadView<RevisionResource> {
        private final TestSubmitType test;

        @Inject
        Get(TestSubmitType test) {
            this.test = test;
        }

        public SubmitType apply(RevisionResource resource) throws AuthException, BadRequestException {
            return this.test.apply(resource, null);
        }
    }
}

