/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AuthType;
import com.google.gerrit.server.auth.openid.OpenIdProviderPattern;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.XsrfException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class AuthConfig {
    private final AuthType authType;
    private final String httpHeader;
    private final String httpDisplaynameHeader;
    private final String httpEmailHeader;
    private final String registerPageUrl;
    private final boolean trustContainerAuth;
    private final boolean enableRunAs;
    private final boolean userNameToLowerCase;
    private final boolean gitBasicAuth;
    private final String loginUrl;
    private final String logoutUrl;
    private final String openIdSsoUrl;
    private final List<String> openIdDomains;
    private final List<OpenIdProviderPattern> trustedOpenIDs;
    private final List<OpenIdProviderPattern> allowedOpenIDs;
    private final String cookiePath;
    private final boolean cookieSecure;
    private final SignedToken emailReg;
    private final SignedToken restToken;

    @Inject
    AuthConfig(@GerritServerConfig Config cfg) throws XsrfException {
        int age;
        this.authType = AuthConfig.toType(cfg);
        this.httpHeader = cfg.getString("auth", null, "httpheader");
        this.httpDisplaynameHeader = cfg.getString("auth", null, "httpdisplaynameheader");
        this.httpEmailHeader = cfg.getString("auth", null, "httpemailheader");
        this.loginUrl = cfg.getString("auth", null, "loginurl");
        this.logoutUrl = cfg.getString("auth", null, "logouturl");
        this.registerPageUrl = cfg.getString("auth", null, "registerPageUrl");
        this.openIdSsoUrl = cfg.getString("auth", null, "openidssourl");
        this.openIdDomains = Arrays.asList(cfg.getStringList("auth", null, "openIdDomain"));
        this.trustedOpenIDs = AuthConfig.toPatterns(cfg, "trustedOpenID");
        this.allowedOpenIDs = AuthConfig.toPatterns(cfg, "allowedOpenID");
        this.cookiePath = cfg.getString("auth", null, "cookiepath");
        this.cookieSecure = cfg.getBoolean("auth", "cookiesecure", false);
        this.trustContainerAuth = cfg.getBoolean("auth", "trustContainerAuth", false);
        this.enableRunAs = cfg.getBoolean("auth", null, "enableRunAs", true);
        this.gitBasicAuth = cfg.getBoolean("auth", "gitBasicAuth", false);
        this.userNameToLowerCase = cfg.getBoolean("auth", "userNameToLowerCase", false);
        String key = cfg.getString("auth", null, "registerEmailPrivateKey");
        if (key != null && !key.isEmpty()) {
            age = (int)ConfigUtil.getTimeUnit(cfg, "auth", null, "maxRegisterEmailTokenAge", TimeUnit.SECONDS.convert(12L, TimeUnit.HOURS), TimeUnit.SECONDS);
            this.emailReg = new SignedToken(age, key);
        } else {
            this.emailReg = null;
        }
        key = cfg.getString("auth", null, "restTokenPrivateKey");
        if (key != null && !key.isEmpty()) {
            age = (int)ConfigUtil.getTimeUnit(cfg, "auth", null, "maxRestTokenAge", 60L, TimeUnit.SECONDS);
            this.restToken = new SignedToken(age, key);
        } else {
            this.restToken = null;
        }
    }

    private static List<OpenIdProviderPattern> toPatterns(Config cfg, String name) {
        String[] s = cfg.getStringList("auth", null, name);
        if (s.length == 0) {
            s = new String[]{"http://", "https://"};
        }
        ArrayList<OpenIdProviderPattern> r = new ArrayList<OpenIdProviderPattern>();
        for (String pattern : s) {
            r.add(OpenIdProviderPattern.create(pattern));
        }
        return Collections.unmodifiableList(r);
    }

    private static AuthType toType(Config cfg) {
        return ConfigUtil.getEnum(cfg, "auth", null, "type", AuthType.OPENID);
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getLoginHttpHeader() {
        return this.httpHeader;
    }

    public String getHttpDisplaynameHeader() {
        return this.httpDisplaynameHeader;
    }

    public String getHttpEmailHeader() {
        return this.httpEmailHeader;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLogoutURL() {
        return this.logoutUrl;
    }

    public String getOpenIdSsoUrl() {
        return this.openIdSsoUrl;
    }

    public List<String> getOpenIdDomains() {
        return this.openIdDomains;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public boolean getCookieSecure() {
        return this.cookieSecure;
    }

    public SignedToken getEmailRegistrationToken() {
        return this.emailReg;
    }

    public SignedToken getRestToken() {
        return this.restToken;
    }

    public List<OpenIdProviderPattern> getAllowedOpenIDs() {
        return this.allowedOpenIDs;
    }

    public boolean isTrustContainerAuth() {
        return this.trustContainerAuth;
    }

    public boolean isRunAsEnabled() {
        return this.enableRunAs;
    }

    public boolean isUserNameToLowerCase() {
        return this.userNameToLowerCase;
    }

    public boolean isGitBasicAuth() {
        return this.gitBasicAuth;
    }

    public boolean isIdentityTrustable(Collection<AccountExternalId> ids) {
        switch (this.getAuthType()) {
            case DEVELOPMENT_BECOME_ANY_ACCOUNT: 
            case HTTP: 
            case HTTP_LDAP: 
            case LDAP: 
            case LDAP_BIND: 
            case CLIENT_SSL_CERT_LDAP: 
            case CUSTOM_EXTENSION: 
            case OAUTH: {
                return true;
            }
            case OPENID_SSO: {
                return true;
            }
            case OPENID: {
                for (AccountExternalId e : ids) {
                    if (this.isTrusted(e)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isTrusted(AccountExternalId id) {
        if (id.isScheme("mailto:")) {
            return true;
        }
        if (id.isScheme("uuid:")) {
            return true;
        }
        if (id.isScheme("username:")) {
            return true;
        }
        for (OpenIdProviderPattern p : this.trustedOpenIDs) {
            if (!p.matches(id)) continue;
            return true;
        }
        return false;
    }

    public String getRegisterPageUrl() {
        return this.registerPageUrl;
    }

    public boolean isLdapAuthType() {
        return this.authType == AuthType.LDAP || this.authType == AuthType.LDAP_BIND;
    }
}

