/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProgressMonitor {
    private static final Logger log = LoggerFactory.getLogger(MultiProgressMonitor.class);
    public static final int UNKNOWN = 0;
    private static final char[] SPINNER_STATES = new char[]{'-', '\\', '|', '/'};
    private static final char NO_SPINNER = ' ';
    private final OutputStream out;
    private final String taskName;
    private final List<Task> tasks = new CopyOnWriteArrayList<Task>();
    private int spinnerIndex;
    private char spinnerState = (char)32;
    private boolean done;
    private boolean write = true;
    private final long maxIntervalNanos;

    public MultiProgressMonitor(OutputStream out, String taskName) {
        this(out, taskName, 500L, TimeUnit.MILLISECONDS);
    }

    public MultiProgressMonitor(OutputStream out, String taskName, long maxIntervalTime, TimeUnit maxIntervalUnit) {
        this.out = out;
        this.taskName = taskName;
        this.maxIntervalNanos = TimeUnit.NANOSECONDS.convert(maxIntervalTime, maxIntervalUnit);
    }

    public void waitFor(Future<?> workerFuture) throws ExecutionException {
        this.waitFor(workerFuture, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Future<?> workerFuture, long timeoutTime, TimeUnit timeoutUnit) throws ExecutionException {
        long overallStart = System.nanoTime();
        String detailMessage = "";
        long deadline = timeoutTime > 0L ? overallStart + TimeUnit.NANOSECONDS.convert(timeoutTime, timeoutUnit) : 0L;
        MultiProgressMonitor multiProgressMonitor = this;
        synchronized (multiProgressMonitor) {
            long left = this.maxIntervalNanos;
            while (!this.done) {
                long start = System.nanoTime();
                try {
                    TimeUnit.NANOSECONDS.timedWait(this, left);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException(e);
                }
                long now = System.nanoTime();
                if (deadline > 0L && now > deadline) {
                    workerFuture.cancel(true);
                    if (!workerFuture.isCancelled()) break;
                    detailMessage = String.format("(timeout %sms, cancelled)", TimeUnit.MILLISECONDS.convert(now - deadline, TimeUnit.NANOSECONDS));
                    log.warn(String.format("MultiProgressMonitor worker killed after %sms" + detailMessage, TimeUnit.MILLISECONDS.convert(now - overallStart, TimeUnit.NANOSECONDS)));
                    break;
                }
                if ((left -= now - start) <= 0L) {
                    this.moveSpinner();
                    left = this.maxIntervalNanos;
                }
                this.sendUpdate();
                if (this.done || !workerFuture.isDone()) continue;
                log.warn("MultiProgressMonitor worker did not call end() before returning");
                this.end();
            }
            this.sendDone();
        }
        try {
            workerFuture.get(this.maxIntervalNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
        catch (CancellationException e) {
            throw new ExecutionException(detailMessage, e);
        }
        catch (TimeoutException e) {
            workerFuture.cancel(true);
            throw new ExecutionException(e);
        }
    }

    private synchronized void wakeUp() {
        this.notifyAll();
    }

    public Task beginSubTask(String subTask, int subTaskWork) {
        Task task = new Task(subTask, subTaskWork);
        this.tasks.add(task);
        return task;
    }

    public synchronized void end() {
        this.done = true;
        this.wakeUp();
    }

    private void sendDone() {
        this.spinnerState = (char)32;
        StringBuilder s = this.format();
        boolean any = false;
        for (Task t : this.tasks) {
            if (t.count == 0) continue;
            any = true;
            break;
        }
        if (any) {
            s.append(",");
        }
        s.append(" done    \n");
        this.send(s);
    }

    private void moveSpinner() {
        this.spinnerIndex = (this.spinnerIndex + 1) % SPINNER_STATES.length;
        this.spinnerState = SPINNER_STATES[this.spinnerIndex];
    }

    private void sendUpdate() {
        this.send(this.format());
    }

    private StringBuilder format() {
        StringBuilder s = new StringBuilder().append("\r").append(this.taskName).append(':');
        if (!this.tasks.isEmpty()) {
            boolean first = true;
            for (Task t : this.tasks) {
                int count = t.count;
                if (count == 0) continue;
                if (!first) {
                    s.append(',');
                } else {
                    first = false;
                }
                s.append(' ');
                if (!Strings.isNullOrEmpty(t.name)) {
                    s.append(t.name).append(": ");
                }
                if (t.total == 0) {
                    s.append(count);
                    continue;
                }
                s.append(String.format("%d%% (%d/%d)", count * 100 / t.total, count, t.total));
            }
        }
        if (this.spinnerState != ' ') {
            s.append(" (").append(this.spinnerState).append(')');
        }
        return s;
    }

    private void send(StringBuilder s) {
        if (this.write) {
            try {
                this.out.write(Constants.encode(s.toString()));
                this.out.flush();
            }
            catch (IOException e) {
                this.write = false;
            }
        }
    }

    public class Task
    implements ProgressMonitor {
        private final String name;
        private final int total;
        private int count;
        private int lastPercent;

        Task(String subTaskName, int totalWork) {
            this.name = subTaskName;
            this.total = totalWork;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(int completed) {
            boolean w = false;
            Task task = this;
            synchronized (task) {
                int percent;
                this.count += completed;
                if (this.total != 0 && (percent = this.count * 100 / this.total) > this.lastPercent) {
                    this.lastPercent = percent;
                    w = true;
                }
            }
            if (w) {
                MultiProgressMonitor.this.wakeUp();
            }
        }

        public void end() {
            if (this.total == 0 && this.getCount() > 0) {
                MultiProgressMonitor.this.wakeUp();
            }
        }

        @Override
        public void start(int totalTasks) {
        }

        @Override
        public void beginTask(String title, int totalWork) {
        }

        @Override
        public void endTask() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        public synchronized int getCount() {
            return this.count;
        }
    }
}

