/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.validators.UploadValidationException;
import com.google.gerrit.server.git.validators.UploadValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

public class UploadValidators
implements PreUploadHook {
    private final DynamicSet<UploadValidationListener> uploadValidationListeners;
    private final Project project;
    private final Repository repository;
    private final String remoteHost;

    @Inject
    UploadValidators(DynamicSet<UploadValidationListener> uploadValidationListeners, @Assisted Project project, @Assisted Repository repository, @Assisted String remoteHost) {
        this.uploadValidationListeners = uploadValidationListeners;
        this.project = project;
        this.repository = repository;
        this.remoteHost = remoteHost;
    }

    @Override
    public void onSendPack(UploadPack up, Collection<? extends ObjectId> wants, Collection<? extends ObjectId> haves) throws ServiceMayNotContinueException {
        for (UploadValidationListener validator : this.uploadValidationListeners) {
            try {
                validator.onPreUpload(this.repository, this.project, this.remoteHost, up, wants, haves);
            }
            catch (ValidationException e) {
                throw new UploadValidationException(e.getMessage());
            }
        }
    }

    @Override
    public void onBeginNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntOffered) throws ServiceMayNotContinueException {
    }

    @Override
    public void onEndNegotiateRound(UploadPack up, Collection<? extends ObjectId> wants, int cntCommon, int cntNotFound, boolean ready) throws ServiceMayNotContinueException {
    }

    public static interface Factory {
        public UploadValidators create(Project var1, Repository var2, String var3);
    }
}

