/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class NotesMigration {
    private final boolean write;
    private final boolean readPatchSetApprovals;
    private final boolean readChangeMessages;
    private final boolean readPublishedComments;

    @VisibleForTesting
    static NotesMigration allEnabled() {
        Config cfg = new Config();
        cfg.setBoolean("notedb", null, "write", true);
        cfg.setBoolean("notedb", "patchSetApprovals", "read", true);
        cfg.setBoolean("notedb", "changeMessages", "read", true);
        cfg.setBoolean("notedb", "publishedComments", "read", true);
        return new NotesMigration(cfg);
    }

    @Inject
    NotesMigration(@GerritServerConfig Config cfg) {
        this.write = cfg.getBoolean("notedb", null, "write", false);
        this.readPatchSetApprovals = cfg.getBoolean("notedb", "patchSetApprovals", "read", false);
        this.readChangeMessages = cfg.getBoolean("notedb", "changeMessages", "read", false);
        this.readPublishedComments = cfg.getBoolean("notedb", "publishedComments", "read", false);
    }

    public boolean write() {
        return this.write;
    }

    public boolean readPatchSetApprovals() {
        return this.readPatchSetApprovals;
    }

    public boolean readChangeMessages() {
        return this.readChangeMessages;
    }

    public boolean readPublishedComments() {
        return this.readPublishedComments;
    }
}

