/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.CommitResource;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class CommitsCollection
implements ChildCollection<ProjectResource, CommitResource> {
    private final DynamicMap<RestView<CommitResource>> views;
    private final GitRepositoryManager repoManager;

    @Inject
    public CommitsCollection(DynamicMap<RestView<CommitResource>> views, GitRepositoryManager repoManager) {
        this.views = views;
        this.repoManager = repoManager;
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    /*
     * Loose catch block
     */
    @Override
    public CommitResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException {
        ObjectId objectId;
        try {
            objectId = ObjectId.fromString(id.get());
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException(id);
        }
        try (Repository repo = this.repoManager.openRepository(parent.getNameKey());){
            try (RevWalk rw = new RevWalk(repo);){
                RevCommit commit = rw.parseCommit(objectId);
                if (!parent.getControl().canReadCommit(rw, commit)) {
                    throw new ResourceNotFoundException(id);
                }
                for (int i = 0; i < commit.getParentCount(); ++i) {
                    rw.parseCommit(commit.getParent(i));
                }
                CommitResource commitResource = new CommitResource(parent.getControl(), commit);
                return commitResource;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @Override
    public DynamicMap<RestView<CommitResource>> views() {
        return this.views;
    }
}

