/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;

class ReviewerPredicate
extends IndexPredicate<ChangeData> {
    private final Account.Id id;
    private boolean allowDrafts;

    ReviewerPredicate(Account.Id id, boolean allowDrafts) {
        super(ChangeField.REVIEWER, id.toString());
        this.id = id;
        this.allowDrafts = allowDrafts;
    }

    Account.Id getAccountId() {
        return this.id;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        if (!this.allowDrafts && object.change().getStatus() == Change.Status.DRAFT) {
            return false;
        }
        for (Account.Id accountId : object.reviewers().values()) {
            if (!this.id.equals(accountId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 2;
    }
}

