/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;

public abstract class SortKeyPredicate
extends IndexPredicate<ChangeData> {
    protected final Schema<ChangeData> schema;
    protected final Provider<ReviewDb> dbProvider;

    public static boolean hasSortKeyField(Schema<ChangeData> schema) {
        return SortKeyPredicate.sortkeyFieldOrNull(schema) != null;
    }

    private static long parseSortKey(Schema<ChangeData> schema, String value) {
        FieldDef<ChangeData, ?> field = schema.getFields().get(ChangeField.SORTKEY.getName());
        if (field == ChangeField.SORTKEY) {
            return ChangeUtil.parseSortKey(value);
        }
        return ChangeField.legacyParseSortKey(value);
    }

    private static FieldDef<ChangeData, ?> sortkeyFieldOrNull(Schema<ChangeData> schema) {
        if (schema == null) {
            return ChangeField.LEGACY_SORTKEY;
        }
        FieldDef<ChangeData, ?> f = schema.getFields().get(ChangeField.SORTKEY.getName());
        if (f != null) {
            return f;
        }
        return schema.getFields().get(ChangeField.LEGACY_SORTKEY.getName());
    }

    private static FieldDef<ChangeData, ?> sortkeyField(Schema<ChangeData> schema) {
        return Preconditions.checkNotNull(SortKeyPredicate.sortkeyFieldOrNull(schema), "schema missing sortkey field, found: %s", schema);
    }

    SortKeyPredicate(Schema<ChangeData> schema, Provider<ReviewDb> dbProvider, String name, String value) {
        super(SortKeyPredicate.sortkeyField(schema), name, value);
        this.schema = schema;
        this.dbProvider = dbProvider;
    }

    @Override
    public int getCost() {
        return 1;
    }

    public abstract long getMinValue(Schema<ChangeData> var1);

    public abstract long getMaxValue(Schema<ChangeData> var1);

    public abstract SortKeyPredicate copy(String var1);

    public static class After
    extends SortKeyPredicate {
        After(@Nullable Schema<ChangeData> schema, Provider<ReviewDb> dbProvider, String value) {
            super(schema, dbProvider, "sortkey_after", value);
        }

        @Override
        public long getMinValue(Schema<ChangeData> schema) {
            return SortKeyPredicate.parseSortKey(schema, this.getValue());
        }

        @Override
        public long getMaxValue(Schema<ChangeData> schema) {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean match(ChangeData cd) throws OrmException {
            Change change = cd.change();
            return change != null && change.getSortKey().compareTo(this.getValue()) > 0;
        }

        @Override
        public After copy(String newValue) {
            return new After(this.schema, this.dbProvider, newValue);
        }
    }

    public static class Before
    extends SortKeyPredicate {
        Before(@Nullable Schema<ChangeData> schema, Provider<ReviewDb> dbProvider, String value) {
            super(schema, dbProvider, "sortkey_before", value);
        }

        @Override
        public long getMinValue(Schema<ChangeData> schema) {
            return 0L;
        }

        @Override
        public long getMaxValue(Schema<ChangeData> schema) {
            return SortKeyPredicate.parseSortKey(schema, this.getValue());
        }

        @Override
        public boolean match(ChangeData cd) throws OrmException {
            Change change = cd.change();
            return change != null && change.getSortKey().compareTo(this.getValue()) < 0;
        }

        @Override
        public Before copy(String newValue) {
            return new Before(this.schema, this.dbProvider, newValue);
        }
    }
}

