/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.persistence.DataSourceInterceptor;
import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gwtorm.jdbc.SimpleDataSource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.jgit.lib.Config;

@Singleton
public class DataSourceProvider
implements Provider<DataSource>,
LifecycleListener {
    public static final int DEFAULT_POOL_LIMIT = 8;
    private final SitePaths site;
    private final Config cfg;
    private final Context ctx;
    private final DataSourceType dst;
    private DataSource ds;

    @Inject
    protected DataSourceProvider(SitePaths site, @GerritServerConfig Config cfg, Context ctx, DataSourceType dst) {
        this.site = site;
        this.cfg = cfg;
        this.ctx = ctx;
        this.dst = dst;
    }

    @Override
    public synchronized DataSource get() {
        if (this.ds == null) {
            this.ds = this.open(this.site, this.cfg, this.ctx, this.dst);
        }
        return this.ds;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        if (this.ds instanceof BasicDataSource) {
            try {
                ((BasicDataSource)this.ds).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private DataSource open(SitePaths site, Config cfg, Context context, DataSourceType dst) {
        String url;
        ConfigSection dbs = new ConfigSection(cfg, "database");
        String driver = dbs.optional("driver");
        if (Strings.isNullOrEmpty(driver)) {
            driver = dst.getDriver();
        }
        if (Strings.isNullOrEmpty(url = dbs.optional("url"))) {
            url = dst.getUrl();
        }
        String username = dbs.optional("username");
        String password = dbs.optional("password");
        String interceptor = dbs.optional("dataSourceInterceptorClass");
        boolean usePool = context == Context.SINGLE_USER ? false : cfg.getBoolean("database", "connectionpool", dst.usePool());
        if (usePool) {
            BasicDataSource ds = new BasicDataSource();
            ds.setDriverClassName(driver);
            ds.setUrl(url);
            if (username != null && !username.isEmpty()) {
                ds.setUsername(username);
            }
            if (password != null && !password.isEmpty()) {
                ds.setPassword(password);
            }
            ds.setMaxActive(cfg.getInt("database", "poollimit", 8));
            ds.setMinIdle(cfg.getInt("database", "poolminidle", 4));
            ds.setMaxIdle(cfg.getInt("database", "poolmaxidle", 4));
            ds.setMaxWait(ConfigUtil.getTimeUnit(cfg, "database", null, "poolmaxwait", TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS));
            ds.setInitialSize(ds.getMinIdle());
            return this.intercept(interceptor, ds);
        }
        try {
            Properties p = new Properties();
            p.setProperty("driver", driver);
            p.setProperty("url", url);
            if (username != null) {
                p.setProperty("user", username);
            }
            if (password != null) {
                p.setProperty("password", password);
            }
            return this.intercept(interceptor, new SimpleDataSource(p));
        }
        catch (SQLException se) {
            throw new ProvisionException("Database unavailable", se);
        }
    }

    private DataSource intercept(String interceptor, DataSource ds) {
        if (interceptor == null) {
            return ds;
        }
        try {
            Constructor<?> c = Class.forName(interceptor).getConstructor(new Class[0]);
            DataSourceInterceptor datasourceInterceptor = (DataSourceInterceptor)c.newInstance(new Object[0]);
            return datasourceInterceptor.intercept("reviewDb", ds);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ProvisionException("Cannot intercept datasource", e);
        }
    }

    public static enum Context {
        SINGLE_USER,
        MULTI_USER;

    }
}

