/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_86;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Schema_87
extends SchemaVersion {
    @Inject
    Schema_87(Provider<Schema_86> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        for (AccountGroup.Id id : this.scanSystemGroups(db)) {
            AccountGroup group = db.accountGroups().get(id);
            if (group == null || !SystemGroupBackend.isSystemGroup(group.getGroupUUID())) continue;
            db.accountGroups().delete(Collections.singleton(group));
            db.accountGroupNames().deleteKeys(Collections.singleton(group.getNameKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<AccountGroup.Id> scanSystemGroups(ReviewDb db) throws SQLException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (Statement stmt = s.getConnection().createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT group_id FROM account_groups WHERE group_type = 'SYSTEM'");
            HashSet<AccountGroup.Id> ids = new HashSet<AccountGroup.Id>();
            while (rs.next()) {
                ids.add(new AccountGroup.Id(rs.getInt(1)));
            }
            HashSet<AccountGroup.Id> hashSet = ids;
            return hashSet;
        }
    }
}

