/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.securestore;

import com.google.common.base.Objects;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.gerrit.server.securestore.SecureStoreException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class SecureStoreData {
    public final File pluginFile;
    public final String storeName;
    public final String className;

    public SecureStoreData(String pluginName, String className, File jarFile, String storeName) {
        this.className = className;
        this.pluginFile = jarFile;
        this.storeName = String.format("%s/%s", pluginName, storeName);
    }

    public String getStoreName() {
        return this.storeName;
    }

    public Class<? extends SecureStore> load() {
        return this.load(this.pluginFile);
    }

    public Class<? extends SecureStore> load(File pluginFile) {
        try {
            URL[] pluginJarUrls = new URL[]{pluginFile.toURI().toURL()};
            ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
            URLClassLoader newClassLoader = new URLClassLoader(pluginJarUrls, currentCL);
            Thread.currentThread().setContextClassLoader(newClassLoader);
            return newClassLoader.loadClass(this.className);
        }
        catch (Exception e) {
            throw new SecureStoreException(String.format("Cannot load secure store implementation for %s", this.storeName), e);
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("storeName", this.storeName).add("className", this.className).add("file", this.pluginFile).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecureStoreData) {
            SecureStoreData o = (SecureStoreData)obj;
            return this.storeName.equals(o.storeName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.storeName);
    }
}

