/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import com.google.gerrit.server.git.GitRepositoryManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.BlobBasedConfig;

public class SubmoduleSectionParser {
    private final BlobBasedConfig bbc;
    private final String thisServer;
    private final Branch.NameKey superProjectBranch;
    private final GitRepositoryManager repoManager;

    public SubmoduleSectionParser(BlobBasedConfig bbc, String thisServer, Branch.NameKey superProjectBranch, GitRepositoryManager repoManager) {
        this.bbc = bbc;
        this.thisServer = thisServer;
        this.superProjectBranch = superProjectBranch;
        this.repoManager = repoManager;
    }

    public List<SubmoduleSubscription> parseAllSections() {
        ArrayList<SubmoduleSubscription> parsedSubscriptions = new ArrayList<SubmoduleSubscription>();
        for (String id : this.bbc.getSubsections("submodule")) {
            SubmoduleSubscription subscription = this.parse(id);
            if (subscription == null) continue;
            parsedSubscriptions.add(subscription);
        }
        return parsedSubscriptions;
    }

    private SubmoduleSubscription parse(String id) {
        String url = this.bbc.getString("submodule", id, "url");
        String path = this.bbc.getString("submodule", id, "path");
        String branch = this.bbc.getString("submodule", id, "branch");
        try {
            if (url != null && url.length() > 0 && path != null && path.length() > 0 && branch != null && branch.length() > 0) {
                boolean urlIsRelative = url.startsWith("../");
                String server = null;
                if (!urlIsRelative) {
                    server = new URI(url).getHost();
                }
                if (urlIsRelative || server != null && server.equalsIgnoreCase(this.thisServer)) {
                    if (branch.equals(".")) {
                        branch = this.superProjectBranch.get();
                    } else if (!branch.startsWith("refs/")) {
                        branch = "refs/heads/" + branch;
                    }
                    String urlExtractedPath = new URI(url).getPath();
                    int fromIndex = urlExtractedPath.length() - 1;
                    while (fromIndex > 0) {
                        String projectName = urlExtractedPath.substring((fromIndex = urlExtractedPath.lastIndexOf(47, fromIndex - 1)) + 1);
                        if (projectName.endsWith(".git")) {
                            projectName = projectName.substring(0, projectName.length() - ".git".length());
                        }
                        if (!this.repoManager.list().contains(new Project.NameKey(projectName))) continue;
                        return new SubmoduleSubscription(this.superProjectBranch, new Branch.NameKey(new Project.NameKey(projectName), branch), path);
                    }
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

