/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.util.concurrent.Atomics;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.RequestCleanup;
import com.google.gerrit.server.git.ProjectRunnable;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.CommandExecutor;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gerrit.util.cli.EndOfOptionsHandler;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshException;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.ExitCallback;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(BaseCommand.class);
    public static final String ENC = "UTF-8";
    private static final int PRIVATE_STATUS = 0x40000000;
    static final int STATUS_CANCEL = 0x40000001;
    static final int STATUS_NOT_FOUND = 0x40000002;
    public static final int STATUS_NOT_ADMIN = 0x40000003;
    @Option(name="--", usage="end of options", handler=EndOfOptionsHandler.class)
    private boolean endOfOptions;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    private ExitCallback exit;
    @Inject
    private SshScope sshScope;
    @Inject
    private CmdLineParser.Factory cmdLineParserFactory;
    @Inject
    private RequestCleanup cleanup;
    @Inject
    @CommandExecutor
    private WorkQueue.Executor executor;
    @Inject
    private Provider<CurrentUser> userProvider;
    @Inject
    private Provider<SshScope.Context> contextProvider;
    @Inject(optional=true)
    @PluginName
    private String pluginName;
    private final AtomicReference<Future<?>> task = Atomics.newReference();
    private String commandName = "";
    private String[] argv;

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.exit = callback;
    }

    @Nullable
    protected String getPluginName() {
        return this.pluginName;
    }

    protected String getName() {
        return this.commandName;
    }

    void setName(String prefix) {
        this.commandName = prefix;
    }

    public String[] getArguments() {
        return this.argv;
    }

    public void setArguments(String[] argv) {
        this.argv = argv;
    }

    @Override
    public void destroy() {
        Future future = this.task.getAndSet(null);
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
    }

    protected void provideStateTo(Command cmd) {
        cmd.setInputStream(this.in);
        cmd.setOutputStream(this.out);
        cmd.setErrorStream(this.err);
        cmd.setExitCallback(this.exit);
    }

    protected void parseCommandLine() throws UnloggedFailure {
        this.parseCommandLine(this);
    }

    protected void parseCommandLine(Object options) throws UnloggedFailure {
        CmdLineParser clp;
        block5: {
            clp = this.newCmdLineParser(options);
            try {
                clp.parseArgument(this.argv);
            }
            catch (IllegalArgumentException err) {
                if (!clp.wasHelpRequestedByOption()) {
                    throw new UnloggedFailure(1, "fatal: " + err.getMessage());
                }
            }
            catch (CmdLineException err) {
                if (clp.wasHelpRequestedByOption()) break block5;
                throw new UnloggedFailure(1, "fatal: " + err.getMessage());
            }
        }
        if (clp.wasHelpRequestedByOption()) {
            StringWriter msg = new StringWriter();
            clp.printDetailedUsage(this.commandName, msg);
            msg.write(this.usage());
            throw new UnloggedFailure(1, msg.toString());
        }
    }

    protected String usage() {
        return "";
    }

    protected CmdLineParser newCmdLineParser(Object options) {
        return this.cmdLineParserFactory.create(options);
    }

    protected void startThread(final Runnable thunk) {
        this.startThread(new CommandRunnable(){

            @Override
            public void run() throws Exception {
                thunk.run();
            }
        });
    }

    protected void startThread(CommandRunnable thunk) {
        TaskThunk tt = new TaskThunk(thunk);
        if (this.isAdminHighPriorityCommand() && this.userProvider.get().getCapabilities().canAdministrateServer()) {
            new Thread((Runnable)tt, tt.toString()).start();
        } else {
            this.task.set(this.executor.submit(tt));
        }
    }

    private final boolean isAdminHighPriorityCommand() {
        return this.getClass().getAnnotation(AdminHighPriorityCommand.class) != null;
    }

    protected void onExit(int rc) {
        this.exit.onExit(rc);
        if (this.cleanup != null) {
            this.cleanup.run();
        }
    }

    protected static PrintWriter toPrintWriter(OutputStream o) {
        try {
            return new PrintWriter(new BufferedWriter(new OutputStreamWriter(o, ENC)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM lacks UTF-8 encoding", e);
        }
    }

    private int handleError(Throwable e) {
        if (e.getClass() == IOException.class && "Pipe closed".equals(e.getMessage()) || e.getClass() == SshException.class && "Already closed".equals(e.getMessage()) || e.getClass() == InterruptedIOException.class) {
            return 127;
        }
        if (!(e instanceof UnloggedFailure)) {
            StringBuilder m = new StringBuilder();
            m.append("Internal server error");
            if (this.userProvider.get().isIdentifiedUser()) {
                IdentifiedUser u = (IdentifiedUser)this.userProvider.get();
                m.append(" (user ");
                m.append(u.getAccount().getUserName());
                m.append(" account ");
                m.append(u.getAccountId());
                m.append(")");
            }
            m.append(" during ");
            m.append(this.contextProvider.get().getCommandLine());
            log.error(m.toString(), e);
        }
        if (e instanceof Failure) {
            Failure f = (Failure)e;
            try {
                this.err.write((f.getMessage() + "\n").getBytes(ENC));
                this.err.flush();
            }
            catch (IOException u) {
            }
            catch (Throwable e2) {
                log.warn("Cannot send failure message to client", e2);
            }
            return f.exitCode;
        }
        try {
            this.err.write("fatal: internal server error\n".getBytes(ENC));
            this.err.flush();
        }
        catch (IOException f) {
        }
        catch (Throwable e2) {
            log.warn("Cannot send internal server error message to client", e2);
        }
        return 128;
    }

    protected UnloggedFailure die(String msg) {
        return new UnloggedFailure(1, "fatal: " + msg);
    }

    protected UnloggedFailure die(Throwable why) {
        return new UnloggedFailure(1, "fatal: " + why.getMessage(), why);
    }

    public void checkExclusivity(Object arg1, String arg1name, Object arg2, String arg2name) throws UnloggedFailure {
        if (arg1 != null && arg2 != null) {
            throw new UnloggedFailure(String.format("%s and %s options are mutually exclusive.", arg1name, arg2name));
        }
    }

    public static class UnloggedFailure
    extends Failure {
        private static final long serialVersionUID = 1L;

        public UnloggedFailure(String msg) {
            this(1, msg);
        }

        public UnloggedFailure(int exitCode, String msg) {
            this(exitCode, msg, null);
        }

        public UnloggedFailure(int exitCode, String msg, Throwable why) {
            super(exitCode, msg, why);
        }
    }

    public static class Failure
    extends Exception {
        private static final long serialVersionUID = 1L;
        final int exitCode;

        public Failure(int exitCode, String msg) {
            this(exitCode, msg, null);
        }

        public Failure(int exitCode, String msg, Throwable why) {
            super(msg, why);
            this.exitCode = exitCode;
        }
    }

    public static interface ProjectCommandRunnable
    extends CommandRunnable {
        public void executeParseCommand() throws Exception;

        public Project.NameKey getProjectName();
    }

    public static interface CommandRunnable {
        public void run() throws Exception;
    }

    private final class TaskThunk
    implements WorkQueue.CancelableRunnable,
    ProjectRunnable {
        private final CommandRunnable thunk;
        private final SshScope.Context context;
        private final String taskName;
        private Project.NameKey projectName;

        private TaskThunk(CommandRunnable thunk) {
            this.thunk = thunk;
            this.context = (SshScope.Context)BaseCommand.this.contextProvider.get();
            StringBuilder m = new StringBuilder();
            m.append(this.context.getCommandLine());
            if (((CurrentUser)BaseCommand.this.userProvider.get()).isIdentifiedUser()) {
                IdentifiedUser u = (IdentifiedUser)BaseCommand.this.userProvider.get();
                m.append(" (").append(u.getAccount().getUserName()).append(")");
            }
            this.taskName = m.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            TaskThunk taskThunk = this;
            synchronized (taskThunk) {
                SshScope.Context old = BaseCommand.this.sshScope.set(this.context);
                try {
                    BaseCommand.this.onExit(0x40000001);
                }
                finally {
                    BaseCommand.this.sshScope.set(old);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskThunk taskThunk = this;
            synchronized (taskThunk) {
                Thread thisThread = Thread.currentThread();
                String thisName = thisThread.getName();
                int rc = 0;
                SshScope.Context old = BaseCommand.this.sshScope.set(this.context);
                try {
                    this.context.started = TimeUtil.nowMs();
                    thisThread.setName("SSH " + this.taskName);
                    if (this.thunk instanceof ProjectCommandRunnable) {
                        ((ProjectCommandRunnable)this.thunk).executeParseCommand();
                        this.projectName = ((ProjectCommandRunnable)this.thunk).getProjectName();
                    }
                    try {
                        this.thunk.run();
                    }
                    catch (NoSuchProjectException e) {
                        throw new UnloggedFailure(1, e.getMessage());
                    }
                    catch (NoSuchChangeException e) {
                        throw new UnloggedFailure(1, e.getMessage() + " no such change");
                    }
                    BaseCommand.this.out.flush();
                    BaseCommand.this.err.flush();
                }
                catch (Throwable e) {
                    try {
                        BaseCommand.this.out.flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        BaseCommand.this.err.flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    rc = BaseCommand.this.handleError(e);
                }
                finally {
                    try {
                        BaseCommand.this.onExit(rc);
                    }
                    finally {
                        BaseCommand.this.sshScope.set(old);
                        thisThread.setName(thisName);
                    }
                }
            }
        }

        public String toString() {
            return this.taskName;
        }

        @Override
        public Project.NameKey getProjectNameKey() {
            return this.projectName;
        }

        @Override
        public String getRemoteName() {
            return null;
        }

        @Override
        public boolean hasCustomizedPrint() {
            return false;
        }
    }
}

