/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Version;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.ssh.SshAdvertisedAddresses;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.ssh.SshListenAddresses;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.server.util.SocketUtil;
import com.google.gerrit.sshd.GerritGSSAuthenticator;
import com.google.gerrit.sshd.GerritServerSession;
import com.google.gerrit.sshd.NoShell;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES128CTR;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.AES256CTR;
import org.apache.sshd.common.cipher.ARCFOUR128;
import org.apache.sshd.common.cipher.ARCFOUR256;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.forward.TcpipServerChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactoryFactory;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.global.CancelTcpipForwardHandler;
import org.apache.sshd.server.global.KeepAliveHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.apache.sshd.server.global.TcpipForwardHandler;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;
import org.apache.sshd.server.session.SessionFactory;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SshDaemon
extends SshServer
implements SshInfo,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(SshDaemon.class);
    private final List<SocketAddress> listen;
    private final List<String> advertised;
    private final boolean keepAlive;
    private final List<HostKey> hostKeys;
    private volatile IoAcceptor acceptor;
    private final Config cfg;

    @Inject
    SshDaemon(CommandFactory commandFactory, NoShell noShell, PublickeyAuthenticator userAuth, GerritGSSAuthenticator kerberosAuth, KeyPairProvider hostKeyProvider, final IdGenerator idGenerator, @GerritServerConfig Config cfg, final SshLog sshLog, @SshListenAddresses List<SocketAddress> listen, @SshAdvertisedAddresses List<String> advertised) {
        this.setPort(22);
        this.cfg = cfg;
        this.listen = listen;
        this.advertised = advertised;
        this.keepAlive = cfg.getBoolean("sshd", "tcpkeepalive", true);
        this.getProperties().put("server-identification", "GerritCodeReview_" + Version.getVersion() + " (" + super.getVersion() + ")");
        this.getProperties().put("max-auth-requests", String.valueOf(cfg.getInt("sshd", "maxAuthTries", 6)));
        this.getProperties().put("auth-timeout", String.valueOf(TimeUnit.MILLISECONDS.convert(ConfigUtil.getTimeUnit(cfg, "sshd", null, "loginGraceTime", 120L, TimeUnit.SECONDS), TimeUnit.SECONDS)));
        long idleTimeoutSeconds = ConfigUtil.getTimeUnit(cfg, "sshd", null, "idleTimeout", 0L, TimeUnit.SECONDS);
        this.getProperties().put("idle-timeout", String.valueOf(TimeUnit.SECONDS.toMillis(idleTimeoutSeconds)));
        long rekeyTimeLimit = ConfigUtil.getTimeUnit(cfg, "sshd", null, "rekeyTimeLimit", 3600L, TimeUnit.SECONDS);
        this.getProperties().put("rekey-time-limit", String.valueOf(TimeUnit.SECONDS.toMillis(rekeyTimeLimit)));
        this.getProperties().put("rekey-bytes-limit", String.valueOf(cfg.getLong("sshd", "rekeyBytesLimit", 0x40000000L)));
        int maxConnectionsPerUser = cfg.getInt("sshd", "maxConnectionsPerUser", 64);
        if (0 < maxConnectionsPerUser) {
            this.getProperties().put("max-concurrent-sessions", String.valueOf(maxConnectionsPerUser));
        }
        String kerberosKeytab = cfg.getString("sshd", null, "kerberosKeytab");
        String kerberosPrincipal = cfg.getString("sshd", null, "kerberosPrincipal");
        SshSessionBackend backend = cfg.getEnum("sshd", null, "backend", SshSessionBackend.MINA);
        System.setProperty(IoServiceFactoryFactory.class.getName(), backend == SshSessionBackend.MINA ? MinaServiceFactoryFactory.class.getName() : Nio2ServiceFactoryFactory.class.getName());
        if (SecurityUtils.isBouncyCastleRegistered()) {
            this.initProviderBouncyCastle();
        } else {
            this.initProviderJce();
        }
        this.initCiphers(cfg);
        this.initMacs(cfg);
        this.initSignatures();
        this.initChannels();
        this.initForwarding();
        this.initFileSystemFactory();
        this.initSubsystems();
        this.initCompression();
        this.initUserAuth(userAuth, kerberosAuth, kerberosKeytab, kerberosPrincipal);
        this.setKeyPairProvider(hostKeyProvider);
        this.setCommandFactory(commandFactory);
        this.setShellFactory(noShell);
        this.setSessionFactory(new SessionFactory(){

            @Override
            protected AbstractSession createSession(IoSession io) throws Exception {
                if (io instanceof MinaSession && ((MinaSession)io).getSession().getConfig() instanceof SocketSessionConfig) {
                    ((SocketSessionConfig)((MinaSession)io).getSession().getConfig()).setKeepAlive(SshDaemon.this.keepAlive);
                }
                GerritServerSession s = (GerritServerSession)super.createSession(io);
                int id = idGenerator.next();
                SocketAddress peer = io.getRemoteAddress();
                final SshSession sd = new SshSession(id, peer);
                s.setAttribute(SshSession.KEY, sd);
                s.addCloseSessionListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        if (sd.isAuthenticationError()) {
                            sshLog.onAuthFail(sd);
                        }
                    }
                });
                return s;
            }

            @Override
            protected AbstractSession doCreateSession(IoSession ioSession) throws Exception {
                return new GerritServerSession(this.server, ioSession);
            }
        });
        this.setGlobalRequestHandlers(Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler(), new TcpipForwardHandler(), new CancelTcpipForwardHandler()));
        this.hostKeys = this.computeHostKeys();
    }

    @Override
    public List<HostKey> getHostKeys() {
        return this.hostKeys;
    }

    public IoAcceptor getIoAcceptor() {
        return this.acceptor;
    }

    @Override
    public synchronized void start() {
        if (this.acceptor == null && !this.listen.isEmpty()) {
            this.checkConfig();
            if (this.sessionFactory == null) {
                this.sessionFactory = this.createSessionFactory();
            }
            this.sessionFactory.setServer(this);
            this.acceptor = this.createAcceptor();
            try {
                String listenAddress = this.cfg.getString("sshd", null, "listenAddress");
                boolean rewrite = !Strings.isNullOrEmpty(listenAddress) && listenAddress.endsWith(":0");
                this.acceptor.bind(this.listen);
                if (rewrite) {
                    SocketAddress bound = Iterables.getOnlyElement(this.acceptor.getBoundAddresses());
                    this.cfg.setString("sshd", null, "listenAddress", SshDaemon.format((InetSocketAddress)bound));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot bind to " + this.addressList(), e);
            }
            log.info(String.format("Started Gerrit %s on %s", this.version, this.addressList()));
        }
    }

    private static String format(InetSocketAddress s) {
        return String.format("%s:%d", s.getAddress().getHostAddress(), s.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.acceptor != null) {
            try {
                this.acceptor.close(true).await();
                log.info("Stopped Gerrit SSHD");
            }
            catch (InterruptedException e) {
                log.warn("Exception caught while closing", e);
            }
            finally {
                this.acceptor = null;
            }
        }
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        if (this.myHostKeys().isEmpty()) {
            throw new IllegalStateException("No SSHD host key");
        }
    }

    private List<HostKey> computeHostKeys() {
        if (this.listen.isEmpty()) {
            return Collections.emptyList();
        }
        List<PublicKey> keys = this.myHostKeys();
        ArrayList<HostKey> r = new ArrayList<HostKey>();
        for (PublicKey pub : keys) {
            Buffer buf = new Buffer();
            buf.putRawPublicKey(pub);
            byte[] keyBin = buf.getCompactData();
            for (String addr : this.advertised) {
                try {
                    r.add(new HostKey(addr, keyBin));
                }
                catch (JSchException e) {
                    log.warn("Cannot format SSHD host key", e);
                }
            }
        }
        return Collections.unmodifiableList(r);
    }

    private List<PublicKey> myHostKeys() {
        KeyPairProvider p = this.getKeyPairProvider();
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(2);
        SshDaemon.addPublicKey(keys, p, "ssh-rsa");
        SshDaemon.addPublicKey(keys, p, "ssh-dss");
        return keys;
    }

    private static void addPublicKey(Collection<PublicKey> out, KeyPairProvider p, String type) {
        KeyPair pair = p.loadKey(type);
        if (pair != null && pair.getPublic() != null) {
            out.add(pair.getPublic());
        }
    }

    private String addressList() {
        StringBuilder r = new StringBuilder();
        Iterator<SocketAddress> i = this.listen.iterator();
        while (i.hasNext()) {
            r.append(SocketUtil.format(i.next(), 22));
            if (!i.hasNext()) continue;
            r.append(", ");
        }
        return r.toString();
    }

    private void initProviderBouncyCastle() {
        this.setKeyExchangeFactories(Arrays.asList(new DHG14.Factory(), new DHG1.Factory()));
        this.setRandomFactory(new SingletonRandomFactory(new BouncyCastleRandom.Factory()));
    }

    private void initProviderJce() {
        this.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
        this.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
    }

    private void initCiphers(Config cfg) {
        LinkedList<NamedFactory<Cipher>> a = new LinkedList<NamedFactory<Cipher>>();
        a.add(new AES128CBC.Factory());
        a.add(new TripleDESCBC.Factory());
        a.add(new BlowfishCBC.Factory());
        a.add(new AES192CBC.Factory());
        a.add(new AES256CBC.Factory());
        a.add(new AES128CTR.Factory());
        a.add(new AES256CTR.Factory());
        a.add(new ARCFOUR256.Factory());
        a.add(new ARCFOUR128.Factory());
        Iterator i = a.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                log.warn("Disabling cipher " + f.getName() + ": " + e.getMessage() + "; try installing unlimited cryptography extension");
                i.remove();
            }
            catch (Exception e) {
                log.warn("Disabling cipher " + f.getName() + ": " + e.getMessage());
                i.remove();
            }
        }
        a.add(null);
        a.add(new CipherNone.Factory());
        this.setCipherFactories(SshDaemon.filter(cfg, "cipher", a.toArray(new NamedFactory[a.size()])));
    }

    private void initMacs(Config cfg) {
        this.setMacFactories(SshDaemon.filter(cfg, "mac", new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()));
    }

    @SafeVarargs
    private static <T> List<NamedFactory<T>> filter(Config cfg, String key, NamedFactory<T> ... avail) {
        ArrayList<NamedFactory<T>> def = new ArrayList<NamedFactory<T>>();
        for (NamedFactory<T> n : avail) {
            if (n == null) break;
            def.add(n);
        }
        String[] want = cfg.getStringList("sshd", null, key);
        if (want == null || want.length == 0) {
            return def;
        }
        boolean didClear = false;
        for (String setting : want) {
            String name = setting.trim();
            boolean add = true;
            if (name.startsWith("-")) {
                add = false;
                name = name.substring(1).trim();
            } else if (name.startsWith("+")) {
                name = name.substring(1).trim();
            } else if (!didClear) {
                didClear = true;
                def.clear();
            }
            NamedFactory<T> n = SshDaemon.find(name, avail);
            if (n == null) {
                StringBuilder msg = new StringBuilder();
                msg.append("sshd.").append(key).append(" = ").append(name).append(" unsupported; only ");
                for (int i = 0; i < avail.length; ++i) {
                    if (avail[i] == null) continue;
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(avail[i].getName());
                }
                msg.append(" is supported");
                log.error(msg.toString());
                continue;
            }
            if (add) {
                if (def.contains(n)) continue;
                def.add(n);
                continue;
            }
            def.remove(n);
        }
        return def;
    }

    @SafeVarargs
    private static <T> NamedFactory<T> find(String name, NamedFactory<T> ... avail) {
        for (NamedFactory<T> n : avail) {
            if (n == null || !name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    private void initSignatures() {
        this.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory(), new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory()));
    }

    private void initCompression() {
        this.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
    }

    private void initChannels() {
        this.setChannelFactories(Arrays.asList(new ChannelSession.Factory(), new TcpipServerChannel.DirectTcpipFactory()));
    }

    private void initSubsystems() {
        this.setSubsystemFactories(Collections.emptyList());
    }

    private void initUserAuth(PublickeyAuthenticator pubkey, GSSAuthenticator kerberosAuthenticator, String kerberosKeytab, String kerberosPrincipal) {
        ArrayList<NamedFactory<UserAuth>> authFactories = Lists.newArrayList();
        if (kerberosKeytab != null) {
            authFactories.add(new UserAuthGSS.Factory());
            log.info("Enabling kerberos with keytab " + kerberosKeytab);
            if (!new File(kerberosKeytab).canRead()) {
                log.error("Keytab " + kerberosKeytab + " does not exist or is not readable; further errors are possible");
            }
            kerberosAuthenticator.setKeytabFile(kerberosKeytab);
            if (kerberosPrincipal == null) {
                try {
                    kerberosPrincipal = "host/" + InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    kerberosPrincipal = "host/localhost";
                }
            }
            log.info("Using kerberos principal " + kerberosPrincipal);
            if (!kerberosPrincipal.startsWith("host/")) {
                log.warn("Host principal does not start with host/ which most SSH clients will supply automatically");
            }
            kerberosAuthenticator.setServicePrincipalName(kerberosPrincipal);
            this.setGSSAuthenticator(kerberosAuthenticator);
        }
        authFactories.add(new UserAuthPublicKey.Factory());
        this.setUserAuthFactories(authFactories);
        this.setPublickeyAuthenticator(pubkey);
    }

    private void initForwarding() {
        this.setTcpipForwardingFilter(new ForwardingFilter(){

            @Override
            public boolean canForwardAgent(Session session) {
                return false;
            }

            @Override
            public boolean canForwardX11(Session session) {
                return false;
            }

            @Override
            public boolean canListen(SshdSocketAddress address, Session session) {
                return false;
            }

            @Override
            public boolean canConnect(SshdSocketAddress address, Session session) {
                return false;
            }
        });
        this.setTcpipForwarderFactory(new DefaultTcpipForwarderFactory());
    }

    private void initFileSystemFactory() {
        this.setFileSystemFactory(new FileSystemFactory(){

            @Override
            public FileSystemView createFileSystemView(Session session) throws IOException {
                return new FileSystemView(){

                    @Override
                    public SshFile getFile(SshFile baseDir, String file) {
                        return null;
                    }

                    @Override
                    public SshFile getFile(String file) {
                        return null;
                    }

                    @Override
                    public FileSystemView getNormalizedView() {
                        return this;
                    }
                };
            }
        });
    }

    public static enum SshSessionBackend {
        MINA,
        NIO2;

    }
}

