/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.util.cli;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.util.cli.OptionHandlerFactory;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.lang.reflect.ParameterizedType;
import java.util.Map;

@Singleton
public class OptionHandlers {
    private final ImmutableMap<Class<?>, Provider<OptionHandlerFactory<?>>> map;

    public static OptionHandlers empty() {
        ImmutableMap<Class<?>, Provider<OptionHandlerFactory<?>>> m = ImmutableMap.of();
        return new OptionHandlers(m);
    }

    @Inject
    OptionHandlers(Injector parent) {
        this(OptionHandlers.build(parent));
    }

    OptionHandlers(ImmutableMap<Class<?>, Provider<OptionHandlerFactory<?>>> m) {
        this.map = m;
    }

    @Nullable
    OptionHandlerFactory<?> get(Class<?> type) {
        Provider<OptionHandlerFactory<?>> b = this.map.get(type);
        return b != null ? b.get() : null;
    }

    private static ImmutableMap<Class<?>, Provider<OptionHandlerFactory<?>>> build(Injector i) {
        ImmutableMap.Builder<Class<?>, Provider<OptionHandlerFactory<?>>> map = ImmutableMap.builder();
        while (i != null) {
            for (Map.Entry<Key<?>, Binding<?>> e : i.getBindings().entrySet()) {
                TypeLiteral<?> type = e.getKey().getTypeLiteral();
                if (type.getRawType() != OptionHandlerFactory.class || e.getKey().getAnnotation() != null || !(type.getType() instanceof ParameterizedType)) continue;
                map.put(OptionHandlers.getType(type), OptionHandlers.cast(e.getValue()).getProvider());
            }
            i = i.getParent();
        }
        return map.build();
    }

    private static Class<?> getType(TypeLiteral<?> t) {
        ParameterizedType p = (ParameterizedType)t.getType();
        return (Class)p.getActualTypeArguments()[0];
    }

    private static Binding<OptionHandlerFactory<?>> cast(Binding<?> e) {
        return e;
    }
}

