/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.JsonElement;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.server.MethodHandle;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.ValidToken;
import com.google.gwtjsonrpc.server.XsrfException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActiveCall
implements AsyncCallback<Object> {
    protected final HttpServletRequest httpRequest;
    protected final HttpServletResponse httpResponse;
    JsonElement id;
    String versionName;
    JsonElement versionValue;
    SignedToken xsrf;
    String xsrfKeyIn;
    String xsrfKeyOut;
    boolean xsrfValid;
    MethodHandle method;
    String callback;
    Object[] params;
    Object result;
    Throwable externalFailure;
    Throwable internalFailure;
    private Map<String, String> cookies;

    public ActiveCall(HttpServletRequest req, HttpServletResponse resp) {
        this.httpRequest = req;
        this.httpResponse = resp;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpResponse;
    }

    public String getCookie(String name) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
            Cookie[] all = this.httpRequest.getCookies();
            if (all != null) {
                for (Cookie c : all) {
                    this.cookies.put(c.getName(), c.getValue());
                }
            }
        }
        return this.cookies.get(name);
    }

    public ValidToken getCookie(String name, SignedToken sig) {
        String tokstr = this.getCookie(name);
        try {
            return sig.checkToken(tokstr, null);
        }
        catch (XsrfException e) {
            return null;
        }
    }

    public void removeCookie(String name) {
        Cookie c = new Cookie(name, "");
        c.setMaxAge(0);
        c.setPath(this.getHttpServletRequest().getContextPath());
        this.httpResponse.addCookie(c);
    }

    public void setCookie(String name, String value, int age) {
        Cookie c = new Cookie(name, value);
        c.setMaxAge(age);
        c.setPath(this.getHttpServletRequest().getContextPath());
        this.httpResponse.addCookie(c);
    }

    public void setCookie(String name, String value, SignedToken sig) {
        try {
            this.setCookie(name, sig.newToken(value), sig.getMaxAge());
        }
        catch (XsrfException e) {
            // empty catch block
        }
    }

    public String getUser() {
        return this.httpRequest.getRemoteUser();
    }

    public MethodHandle getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setXsrfSignedToken(SignedToken t) {
        this.xsrf = t;
    }

    public final String getXsrfKeyIn() {
        return this.xsrfKeyIn;
    }

    public final void setXsrfKeyOut(String out) {
        this.xsrfKeyOut = out;
    }

    public final String getXsrfKeyOut() {
        return this.xsrfKeyOut;
    }

    public final boolean isXsrfValid() {
        return this.xsrfValid;
    }

    public final boolean requireXsrfValid() {
        if (this.isXsrfValid()) {
            return true;
        }
        this.onFailure(new Exception("Invalid xsrfKey in request"));
        return false;
    }

    public boolean xsrfValidate() throws XsrfException {
        String username = this.getUser();
        StringBuilder b = new StringBuilder();
        if (username != null) {
            b.append("user/");
            b.append(username);
        } else {
            b.append("anonymous");
        }
        String userpath = b.toString();
        ValidToken t = this.xsrf.checkToken(this.getXsrfKeyIn(), userpath);
        if (t == null || t.needsRefresh()) {
            this.setXsrfKeyOut(this.xsrf.newToken(userpath));
        }
        return t != null;
    }

    public final boolean isComplete() {
        return this.result != null || this.externalFailure != null || this.internalFailure != null;
    }

    @Override
    public final void onSuccess(Object result) {
        this.result = result;
        this.externalFailure = null;
        this.internalFailure = null;
    }

    @Override
    public void onFailure(Throwable error) {
        this.result = null;
        this.externalFailure = error;
        this.internalFailure = null;
    }

    public final void onInternalFailure(Throwable error) {
        this.result = null;
        this.externalFailure = null;
        this.internalFailure = error;
    }

    public void noCache() {
        this.httpResponse.setHeader("Expires", "Fri, 01 Jan 1980 00:00:00 GMT");
        this.httpResponse.setHeader("Pragma", "no-cache");
        this.httpResponse.setHeader("Cache-Control", "no-cache, must-revalidate");
    }
}

