/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectOracle
extends SqlDialect {
    public DialectOracle() {
        this.typeNames.put(-5, "NUMBER(19,0)");
        this.typeNames.put(-1, "CLOB");
    }

    @Override
    public boolean handles(String url, Connection c) throws SQLException {
        return url.startsWith("jdbc:oracle:");
    }

    @Override
    public boolean canDetermineIndividualBatchUpdateCounts() {
        return false;
    }

    @Override
    public boolean canDetermineTotalBatchUpdateCount() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listTables(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT table_name FROM user_tables");
            try {
                HashSet<String> tables = new HashSet<String>();
                while (rs.next()) {
                    tables.add(rs.getString(1).toLowerCase());
                }
                hashSet = tables;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listIndexes(Connection db, String tableName) throws SQLException {
        try (PreparedStatement s = db.prepareStatement("SELECT distinct index_name FROM user_indexes WHERE table_name = ?");){
            HashSet<String> hashSet;
            s.setString(1, tableName.toUpperCase());
            ResultSet rs = s.executeQuery();
            try {
                HashSet<String> indexes = new HashSet<String>();
                while (rs.next()) {
                    indexes.add(rs.getString(1).toLowerCase());
                }
                hashSet = indexes;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        try (Statement s = db.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT sequence_name FROM user_sequences");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    @Override
    public void addColumn(StatementExecutor stmt, String tableName, ColumnModel col) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" ADD ");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        stmt.execute(r.toString());
    }

    @Override
    public void renameColumn(StatementExecutor e, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ");
        sb.append(tableName);
        sb.append(" RENAME COLUMN ");
        sb.append(fromColumn);
        sb.append(" TO ");
        sb.append(col.getColumnName());
        e.execute(sb.toString());
    }

    @Override
    public String getNextSequenceValueSql(String seqname) {
        return "SELECT " + seqname + ".nextval FROM dual";
    }

    @Override
    public boolean selectHasLimit() {
        return false;
    }

    @Override
    public boolean isStatementDelimiterSupported() {
        return false;
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        switch (err.getErrorCode()) {
            case 1: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }
}

