/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class IllegalTypeException
extends BuiltinException {
    public static final SymbolTerm TYPE_ERROR = SymbolTerm.intern("type_error", 4);
    public String type;
    public Term culprit;

    public IllegalTypeException(String string, Term term) {
        this.type = string;
        this.culprit = term;
    }

    public IllegalTypeException(Operation operation, int n, String string, Term term) {
        this.goal = operation;
        this.argNo = n;
        this.type = string;
        this.culprit = term;
    }

    @Override
    public Term getMessageTerm() {
        Term[] termArray = new Term[]{new JavaObjectTerm(this.goal), new IntegerTerm(this.argNo), SymbolTerm.create(this.type), this.culprit};
        return new StructureTerm(TYPE_ERROR, termArray);
    }

    @Override
    public String toString() {
        String string = "{TYPE ERROR: " + this.goal.toString();
        if (this.argNo > 0) {
            string = string + " - arg " + this.argNo;
        }
        string = string + ": expected " + this.type;
        string = string + ", found " + this.culprit.toString();
        string = string + "}";
        return string;
    }
}

