/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SessionFactory;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.client.auth.UserAuthPassword;
import org.apache.sshd.client.auth.UserAuthPublicKey;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.session.ClientConnectionService;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ThreadUtils;
import org.bouncycastle.openssl.PasswordFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = new Factory<SshClient>(){

        @Override
        public SshClient create() {
            return new SshClient();
        }
    };
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    private ServerKeyVerifier serverKeyVerifier;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    protected void checkConfig() {
        if (this.getKeyExchangeFactories() == null) {
            throw new IllegalArgumentException("KeyExchangeFactories not set");
        }
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(ThreadUtils.newSingleThreadScheduledExecutor(this.toString() + "-timer"), true);
        }
        if (this.getCipherFactories() == null) {
            throw new IllegalArgumentException("CipherFactories not set");
        }
        if (this.getCompressionFactories() == null) {
            throw new IllegalArgumentException("CompressionFactories not set");
        }
        if (this.getMacFactories() == null) {
            throw new IllegalArgumentException("MacFactories not set");
        }
        if (this.getRandomFactory() == null) {
            throw new IllegalArgumentException("RandomFactory not set");
        }
        if (this.getTcpipForwarderFactory() == null) {
            throw new IllegalArgumentException("TcpipForwarderFactory not set");
        }
        if (this.getServerKeyVerifier() == null) {
            throw new IllegalArgumentException("ServerKeyVerifier not set");
        }
        if (this.getAgentFactory() != null) {
            List<NamedFactory<Channel>> factories = this.getChannelFactories();
            factories = factories == null ? new ArrayList<NamedFactory<Channel>>() : new ArrayList<NamedFactory<Channel>>(factories);
            factories.add(this.getAgentFactory().getChannelForwardingFactory());
            this.setChannelFactories(factories);
        }
        if (this.getIoServiceFactoryFactory() == null) {
            this.setIoServiceFactoryFactory(new DefaultIoServiceFactoryFactory());
        }
        if (this.getServiceFactories() == null) {
            this.setServiceFactories(Arrays.asList(new ClientUserAuthService.Factory(), new ClientConnectionService.Factory()));
        }
        if (this.getUserAuthFactories() == null) {
            this.setUserAuthFactories(Arrays.asList(new UserAuthPublicKey.Factory(), new UserAuthKeyboardInteractive.Factory(), new UserAuthPassword.Factory()));
        }
    }

    public void start() {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.sessionFactory.setClient(this);
        this.connector = this.createConnector();
    }

    public void stop() {
        try {
            this.close(true).await();
        }
        catch (InterruptedException e) {
            this.log.debug("Exception caught while stopping client", e);
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            public void run() {
                SshClient.this.removeSessionTimeout(SshClient.this.sessionFactory);
            }
        }).sequential(this.connector, this.ioServiceFactory).run(new Runnable(){

            public void run() {
                SshClient.this.connector = null;
                SshClient.this.ioServiceFactory = null;
                if (SshClient.this.shutdownExecutor && SshClient.this.executor != null) {
                    SshClient.this.executor.shutdownNow();
                    SshClient.this.executor = null;
                }
            }
        }).build();
    }

    @Deprecated
    public ConnectFuture connect(String host, int port) throws IOException {
        return this.connect(null, host, port);
    }

    public ConnectFuture connect(String username, String host, int port) throws IOException {
        assert (host != null);
        assert (port >= 0);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.connect(username, address);
    }

    @Deprecated
    public ConnectFuture connect(SocketAddress address) {
        return this.connect(null, address);
    }

    public ConnectFuture connect(final String username, SocketAddress address) {
        assert (address != null);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        final DefaultConnectFuture connectFuture = new DefaultConnectFuture(null);
        this.connector.connect(address).addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                } else if (future.getException() != null) {
                    connectFuture.setException(future.getException());
                } else {
                    ClientSessionImpl session = (ClientSessionImpl)AbstractSession.getSession(future.getSession());
                    session.setUsername(username);
                    connectFuture.setSession(session);
                }
            }
        });
        return connectFuture;
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public String toString() {
        return "SshClient[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshClient setUpDefaultClient() {
        return (SshClient)SshBuilder.client().build();
    }

    public static void main(String[] args) throws Exception {
        ConsoleHandler fh = new ConsoleHandler();
        fh.setLevel(Level.FINEST);
        fh.setFormatter(new Formatter(){

            public String format(LogRecord record) {
                String message = this.formatMessage(record);
                String throwable = "";
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println();
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    throwable = sw.toString();
                }
                return String.format("%1$tY-%1$tm-%1$td: %2$-7.7s: %3$-32.32s: %4$s%5$s%n", new Date(record.getMillis()), record.getLevel().getName(), record.getLoggerName(), message, throwable);
            }
        });
        Logger root = Logger.getLogger("");
        for (Handler handler : root.getHandlers()) {
            root.removeHandler(handler);
        }
        root.addHandler(fh);
        int port = 22;
        String host = null;
        String login = System.getProperty("user.name");
        boolean agentForward = false;
        ArrayList<String> command = null;
        int logLevel = 0;
        int socksPort = -1;
        boolean error = false;
        ArrayList<String> identities = new ArrayList<String>();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if (command == null && "-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (command == null && "-D".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                socksPort = Integer.parseInt(args[++i]);
                continue;
            }
            if (command == null && "-l".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                login = args[++i];
                continue;
            }
            if (command == null && "-v".equals(args[i])) {
                ++logLevel;
                continue;
            }
            if (command == null && "-vv".equals(args[i])) {
                logLevel += 2;
                continue;
            }
            if (command == null && "-vvv".equals(args[i])) {
                logLevel += 3;
                continue;
            }
            if (command == null && "-A".equals(args[i])) {
                agentForward = true;
                continue;
            }
            if (command == null && "-a".equals(args[i])) {
                agentForward = false;
                continue;
            }
            if (command == null && "-i".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires and argument: " + args[i]);
                    error = true;
                    break;
                }
                identities.add(args[++i]);
                continue;
            }
            if (command == null && "-o".equals(args[i])) {
                String opt;
                int idx;
                if (i + 1 >= args.length) {
                    System.err.println("option requires and argument: " + args[i]);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    System.err.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if (command == null && args[i].startsWith("-")) {
                System.err.println("illegal option: " + args[i]);
                error = true;
                break;
            }
            if (command == null && host == null) {
                host = args[i];
                continue;
            }
            if (command == null) {
                command = new ArrayList<String>();
            }
            command.add(args[i]);
        }
        if (host == null) {
            System.err.println("hostname required");
            error = true;
        }
        if (error) {
            System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-D socksPort] [-l login] [-p port] [-o option=value] hostname [command]");
            System.exit(-1);
        }
        if (logLevel <= 0) {
            root.setLevel(Level.WARNING);
        } else if (logLevel == 1) {
            root.setLevel(Level.INFO);
        } else if (logLevel == 2) {
            root.setLevel(Level.FINE);
        } else {
            root.setLevel(Level.FINEST);
        }
        KeyPairProvider provider = null;
        ArrayList<String> files = new ArrayList<String>();
        File f = new File(System.getProperty("user.home"), ".ssh/id_dsa");
        if (f.exists() && f.isFile() && f.canRead()) {
            files.add(f.getAbsolutePath());
        }
        if ((f = new File(System.getProperty("user.home"), ".ssh/id_rsa")).exists() && f.isFile() && f.canRead()) {
            files.add(f.getAbsolutePath());
        }
        if ((f = new File(System.getProperty("user.home"), ".ssh/id_ecdsa")).exists() && f.isFile() && f.canRead()) {
            files.add(f.getAbsolutePath());
        }
        if (files.size() > 0) {
            try {
                if (SecurityUtils.isBouncyCastleRegistered()) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class KeyPairProviderLoader
                    implements Callable<KeyPairProvider> {
                        final /* synthetic */ List val$files;

                        KeyPairProviderLoader(List list) {
                            this.val$files = list;
                        }

                        @Override
                        public KeyPairProvider call() throws Exception {
                            return new FileKeyPairProvider(this.val$files.toArray(new String[this.val$files.size()]), new PasswordFinder(){

                                public char[] getPassword() {
                                    try {
                                        System.out.println("Enter password for private key: ");
                                        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                                        String password = r.readLine();
                                        return password.toCharArray();
                                    }
                                    catch (IOException e) {
                                        return null;
                                    }
                                }
                            });
                        }
                    }
                    provider = new KeyPairProviderLoader(files).call();
                }
            }
            catch (Throwable t) {
                System.out.println("Error loading user keys: " + t.getMessage());
            }
        }
        SshClient client = SshClient.setUpDefaultClient();
        client.getProperties().putAll(options);
        client.start();
        client.setKeyPairProvider(provider);
        client.setUserInteraction(new UserInteraction(){

            public void welcome(String banner) {
                System.out.println(banner);
            }

            public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                String[] answers = new String[prompt.length];
                try {
                    for (int i = 0; i < prompt.length; ++i) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                        System.out.print(prompt[i] + " ");
                        answers[i] = r.readLine();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                return answers;
            }
        });
        ClientSession session = ((ConnectFuture)client.connect(login, host, port).await()).getSession();
        session.auth().verify();
        if (socksPort >= 0) {
            session.startDynamicPortForwarding(new SshdSocketAddress("localhost", socksPort));
            Thread.sleep(Long.MAX_VALUE);
        } else {
            ClientChannel channel;
            if (command == null) {
                channel = session.createChannel("shell");
                ((ChannelShell)channel).setAgentForwarding(agentForward);
                channel.setIn(new NoCloseInputStream(System.in));
            } else {
                StringWriter w = new StringWriter();
                for (String cmd : command) {
                    w.append(cmd).append(" ");
                }
                w.close();
                channel = session.createChannel("exec", w.toString());
            }
            channel.setOut(new NoCloseOutputStream(System.out));
            channel.setErr(new NoCloseOutputStream(System.err));
            channel.open().await();
            channel.waitFor(2, 0L);
            session.close(false);
            client.stop();
        }
    }
}

