/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.internal.ArchiveText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;

public final class ZipFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".zip"));

    @Override
    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    @Override
    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        return this.applyFormatOptions(new ZipArchiveOutputStream(s), o);
    }

    @Override
    public void putEntry(ArchiveOutputStream out, String path, FileMode mode, ObjectLoader loader) throws IOException {
        if (path.endsWith("/") && mode != FileMode.TREE) {
            throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().pathDoesNotMatchMode, path, mode));
        }
        if (!path.endsWith("/") && mode == FileMode.TREE) {
            path = path + "/";
        }
        ZipArchiveEntry entry = new ZipArchiveEntry(path);
        if (mode == FileMode.TREE) {
            out.putArchiveEntry(entry);
            out.closeArchiveEntry();
            return;
        }
        if (mode != FileMode.REGULAR_FILE) {
            if (mode == FileMode.EXECUTABLE_FILE || mode == FileMode.SYMLINK) {
                entry.setUnixMode(mode.getBits());
            } else {
                throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().unsupportedMode, mode));
            }
        }
        entry.setSize(loader.getSize());
        out.putArchiveEntry(entry);
        loader.copyTo(out);
        out.closeArchiveEntry();
    }

    @Override
    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof ZipFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

