/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.glue.ServletBinderImpl;
import org.eclipse.jgit.http.server.glue.UrlPipeline;
import org.eclipse.jgit.http.server.glue.WrappedRequest;

class RegexPipeline
extends UrlPipeline {
    private final Pattern pattern;

    RegexPipeline(Pattern pattern, Filter[] filters, HttpServlet servlet) {
        super(filters, servlet);
        this.pattern = pattern;
    }

    @Override
    boolean match(HttpServletRequest req) {
        String pathInfo = req.getPathInfo();
        return pathInfo != null && this.pattern.matcher(pathInfo).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void service(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        String reqInfo = req.getPathInfo();
        if (reqInfo == null) {
            rsp.sendError(404);
            return;
        }
        Matcher cur = this.pattern.matcher(reqInfo);
        if (!cur.matches()) {
            rsp.sendError(404);
            return;
        }
        String reqPath = req.getServletPath();
        Object old = req.getAttribute("org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex");
        try {
            if (1 <= cur.groupCount()) {
                WrappedRequest[] groups = new WrappedRequest[cur.groupCount()];
                for (int groupId = 1; groupId <= cur.groupCount(); ++groupId) {
                    int s = cur.start(groupId);
                    String path = reqPath + reqInfo.substring(0, s);
                    String info = cur.group(groupId);
                    groups[groupId - 1] = new WrappedRequest(req, path, info);
                }
                req.setAttribute("org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex", groups);
                super.service(groups[0], rsp);
            } else {
                String path = reqPath + reqInfo;
                String info = null;
                super.service(new WrappedRequest(req, path, info), rsp);
            }
        }
        finally {
            if (old != null) {
                req.setAttribute("org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex", old);
            } else {
                req.removeAttribute("org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex");
            }
        }
    }

    public String toString() {
        return "Pipeline[regex: " + this.pattern + " ]";
    }

    static class Binder
    extends ServletBinderImpl {
        private final Pattern pattern;

        Binder(String p) {
            this.pattern = Pattern.compile(p);
        }

        Binder(Pattern p) {
            this.pattern = p;
        }

        @Override
        UrlPipeline create() {
            return new RegexPipeline(this.pattern, this.getFilters(), this.getServlet());
        }
    }
}

