/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.audit;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.util.TimeUtil;

public class AuditEvent {
    public static final String UNKNOWN_SESSION_ID = "000000000000000000000000000";
    protected static final Multimap<String, ?> EMPTY_PARAMS = HashMultimap.create();
    public final String sessionId;
    public final CurrentUser who;
    public final long when;
    public final String what;
    public final Multimap<String, ?> params;
    public final Object result;
    public final long timeAtStart;
    public final long elapsed;
    public final UUID uuid;

    public AuditEvent(String sessionId, CurrentUser who, String what, long when, Multimap<String, ?> params, Object result) {
        Preconditions.checkNotNull(what, "what is a mandatory not null param !");
        this.sessionId = Objects.firstNonNull(sessionId, UNKNOWN_SESSION_ID);
        this.who = who;
        this.what = what;
        this.timeAtStart = this.when = when;
        this.params = Objects.firstNonNull(params, EMPTY_PARAMS);
        this.uuid = new UUID();
        this.result = result;
        this.elapsed = TimeUtil.nowMs() - this.timeAtStart;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        return this.uuid.equals(other.uuid);
    }

    public String toString() {
        return String.format("AuditEvent UUID:%s, SID:%s, TS:%d, who:%s, what:%s", this.uuid.get(), this.sessionId, this.when, this.who, this.what);
    }

    public static class UUID {
        protected final String uuid;

        protected UUID() {
            this.uuid = String.format("audit:%s", java.util.UUID.randomUUID().toString());
        }

        public UUID(String n) {
            this.uuid = n;
        }

        public String get() {
            return this.uuid;
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof UUID)) {
                return false;
            }
            return this.uuid.equals(((UUID)obj).uuid);
        }
    }
}

