/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApprovalDetail {
    protected Account.Id account;
    protected List<PatchSetApproval> approvals;
    protected boolean canRemove;
    private Set<String> votable;
    private transient Set<String> approved;
    private transient Set<String> rejected;
    private transient Map<String, Integer> values;
    private transient int hasNonZero;

    public static List<ApprovalDetail> sort(Collection<ApprovalDetail> ads, final int owner) {
        ArrayList<ApprovalDetail> sorted = new ArrayList<ApprovalDetail>(ads);
        Collections.sort(sorted, new Comparator<ApprovalDetail>(){

            @Override
            public int compare(ApprovalDetail o1, ApprovalDetail o2) {
                int byOwner = (o2.account.get() == owner ? 1 : 0) - (o1.account.get() == owner ? 1 : 0);
                return byOwner != 0 ? byOwner : o1.hasNonZero - o2.hasNonZero;
            }
        });
        return sorted;
    }

    protected ApprovalDetail() {
    }

    public ApprovalDetail(Account.Id id) {
        this.account = id;
        this.approvals = new ArrayList<PatchSetApproval>();
    }

    public Account.Id getAccount() {
        return this.account;
    }

    public boolean canRemove() {
        return this.canRemove;
    }

    public void setCanRemove(boolean removeable) {
        this.canRemove = removeable;
    }

    public void approved(String label) {
        if (this.approved == null) {
            this.approved = new HashSet<String>();
        }
        this.approved.add(label);
        this.hasNonZero = 1;
    }

    public void rejected(String label) {
        if (this.rejected == null) {
            this.rejected = new HashSet<String>();
        }
        this.rejected.add(label);
        this.hasNonZero = 1;
    }

    public void votable(String label) {
        if (this.votable == null) {
            this.votable = new HashSet<String>();
        }
        this.votable.add(label);
    }

    public void value(String label, int value) {
        if (this.values == null) {
            this.values = new HashMap<String, Integer>();
        }
        this.values.put(label, value);
        if (value != 0) {
            this.hasNonZero = 1;
        }
    }

    public boolean isApproved(String label) {
        return this.approved != null && this.approved.contains(label);
    }

    public boolean isRejected(String label) {
        return this.rejected != null && this.rejected.contains(label);
    }

    public boolean canVote(String label) {
        return this.votable != null && this.votable.contains(label);
    }

    public int getValue(String label) {
        if (this.values == null) {
            return 0;
        }
        Integer v = this.values.get(label);
        return v != null ? v : 0;
    }
}

