/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Project;
import java.util.ArrayList;
import java.util.List;

public class GarbageCollectionResult {
    protected List<Error> errors = new ArrayList<Error>();

    public void addError(Error e) {
        this.errors.add(e);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public static class Error {
        protected Type type;
        protected Project.NameKey projectName;

        protected Error() {
        }

        public Error(Type type, Project.NameKey projectName) {
            this.type = type;
            this.projectName = projectName;
        }

        public Type getType() {
            return this.type;
        }

        public Project.NameKey getProjectName() {
            return this.projectName;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append((Object)this.type);
            if (this.projectName != null) {
                b.append(" ").append(this.projectName);
            }
            return b.toString();
        }

        public static enum Type {
            GC_ALREADY_SCHEDULED,
            REPOSITORY_NOT_FOUND,
            GC_FAILED;

        }
    }
}

