/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.PageLinks;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.reviewdb.client.AccountGroup;

public class GroupDescriptions {
    @Nullable
    public static AccountGroup toAccountGroup(GroupDescription.Basic group) {
        if (group instanceof GroupDescription.Internal) {
            return ((GroupDescription.Internal)group).getAccountGroup();
        }
        return null;
    }

    public static GroupDescription.Internal forAccountGroup(final AccountGroup group) {
        return new GroupDescription.Internal(){

            @Override
            public AccountGroup.UUID getGroupUUID() {
                return group.getGroupUUID();
            }

            @Override
            public String getName() {
                return group.getName();
            }

            @Override
            public AccountGroup getAccountGroup() {
                return group;
            }

            @Override
            @Nullable
            public String getEmailAddress() {
                return null;
            }

            @Override
            @Nullable
            public String getUrl() {
                return "#" + PageLinks.toGroup(this.getGroupUUID());
            }
        };
    }

    private GroupDescriptions() {
    }
}

