/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.client.Change;
import java.util.ArrayList;
import java.util.List;

public class ReviewResult {
    protected List<Error> errors = new ArrayList<Error>();
    protected Change.Id changeId;

    public void addError(Error e) {
        this.errors.add(e);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public Change.Id getChangeId() {
        return this.changeId;
    }

    public void setChangeId(Change.Id changeId) {
        this.changeId = changeId;
    }

    public static class Error {
        protected Type type;
        protected String message;

        protected Error() {
        }

        public Error(Type type) {
            this.type = type;
            this.message = null;
        }

        public Error(Type type, String message) {
            this.type = type;
            this.message = message;
        }

        public Type getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageOrType() {
            if (this.message != null) {
                return this.message;
            }
            return "" + (Object)((Object)this.type);
        }

        public String toString() {
            String ret = (Object)((Object)this.type) + "";
            if (this.message != null) {
                ret = ret + " " + this.message;
            }
            return ret;
        }

        public static enum Type {
            ABANDON_NOT_PERMITTED,
            RESTORE_NOT_PERMITTED,
            SUBMIT_NOT_PERMITTED,
            SUBMIT_NOT_READY,
            CHANGE_IS_CLOSED,
            CHANGE_NOT_ABANDONED,
            PUBLISH_NOT_PERMITTED,
            DELETE_NOT_PERMITTED,
            RULE_ERROR,
            NOT_A_DRAFT,
            GIT_ERROR,
            DEST_BRANCH_NOT_FOUND,
            EDIT_TOPIC_NAME_NOT_PERMITTED;

        }
    }
}

